// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef CONFIGSCSIWIDGET_H
#define CONFIGSCSIWIDGET_H
#include <qwidget.h>
#include "BusScanner.h"

class ConfigSCSIWidget : public QWidget {
  Q_OBJECT;
 public:
  ConfigSCSIWidget( QWidget *parent=0, const char *name=0);
  ~ConfigSCSIWidget();
  void applySettings();
  protected slots:
    void clickedWriter(int unit);
  void clickedCDROM(int unit);

  void updateWriterButtons();
  void updateCdromButtons();
  void changedWriterHost(int host);
  void changedCdromHost(int host);
 private:
  class QButtonGroup *scsiboxes[2];
  class QRadioButton *scsibuttons[2][MAX_SCSI_UNITS];

  class QSpinBox   *writerhostspin;
  class QSpinBox   *cdromhostspin;

  class BusScanner  *SCSIBus;

  char scsidevs[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][32];
  int cdrom_id;
  int writer_id;
  int cdrom_host;
  int writer_host;
};
#endif
