// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "DataRipper.h"

#include <kapp.h>
#include <klocale.h>

#include <qmessagebox.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "DataRipper.moc"

DataRipper::DataRipper(void):ProcessInterface() {

}

DataRipper::DataRipper(int (*fx)(int argc,char **argv)):ProcessInterface(fx) {

}

bool DataRipper::readDataTrack(int track,char *filename,
			       long int lba_start,long int size_hint) {
  char progressline[64];

  strcpy(imageFilename,filename);

  ripDataTrack(imageFilename,lba_start,size_hint);
  sprintf(progressline,i18n("Extracting data track %d from CD..."),track);
  reportAction(progressline);

  ripflag=-2;


  startProcess();
  return(1);
}

int DataRipper::processCleanup(int retval) {
  // 1=ripping was OK  -1=abort 0=winclose
  // -2=unexpected process term -3= DevError
  // -4=Memory -5=Read -6=Write
  if (retval!=1) remove(imageFilename);
  switch (retval) {
  case -2:
    QMessageBox::critical(0,QString::null,i18n("Reading process died!"));
    break;
  case -3:
    QMessageBox::critical(0,QString::null,
			  i18n("Cannot access the drive! (no disc?)"));
    break;
  case -4:
    QMessageBox::critical(0,QString::null,i18n("Cannot get buffer memory!"));
    break;
  case -5:
    QMessageBox::critical(0,QString::null,i18n("CDROM read error occured!"));
    break;
  case -6:
    QMessageBox::critical(0,QString::null,
			  i18n("Image file write error! (harddisk full?)"));
    break;
  }

  closeProcess();
  if (retval!=1) return(0);
  return(1);
}

int DataRipper::processExited(void) {
  return(ripflag);
}

bool DataRipper::ripDataTrack(char *,long int ,long int) {
  return(false);
}

