
// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef MAINWINDOW_INCLUDED
#define MAINWINDOW_INCLUDED

#include <qwidget.h>
#include <qlistview.h>
#include "TrackListView.h"
#include "TrackListManager.h"
#include <qvbox.h>

#define MAX_TRACKS_PER_PROJECT               120
#define TRACK_COLUMNS                          4

class MainWindow : public QWidget {
  Q_OBJECT;
 public:
  MainWindow( QWidget *parent=0, const char *name=0 );
  ~MainWindow(void);

  protected:
  void saveProjectToConfig(class KConfig *kc);
  void loadProjectFromConfig(class KConfig *kc);
  void checkWidgetEnable(void);
  void openProjectOnCommandline( const QString CmdLineFile );
  virtual void resizeEvent( QResizeEvent *rs);

  protected slots:
    void saveSession(void);
  void writeCD(void);

  void newProject(void);
  void openProject(void);
  void saveProject(void);
  void saveProjectAs(void);
  void setupCopy(void);


  public slots:
  void configDialog();

  void notifyCloseTWin(void);
  void notifyCloseConfigDialog();


  void normalizeMax(void);
  void normalizeAllSame(void);

  void blankAll(void);
  void blankFast(void);
  void blankTrack(void);
  void blankUnreserve(void);
  void blankTail(void);
  void blankUnclose(void);
  void blankSession(void);
 
  void slotSetSizeHint();

 private:


  bool firstInvoke;

  float Colwidth[TRACK_COLUMNS];

  //          class TrackListView     *MWTracklist;
  class TrackListManager  *MWTrackListManager;
  class QPushButton *MWWriteCD;

  class QVBox *ClientArea;

  class TrackWindow   *TrackEdit;
  int                  CurrentTrack;

  //          class QListViewItem *TrackItems[MAX_TRACKS_PER_PROJECT];
  class CDTrack       *ProjectTracks[MAX_TRACKS_PER_PROJECT];
  class ConfigDialog  *theConfigDialog;

  char                 ProjectPath[1024];
};

#endif
