// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef PIPECOPY_INCLUDED
#define PIPECOPY_INCLUDED


#include "ProcessInterface.h"

/**
    @short PipeCopy - class for copying one pipe over to another
    @author Alexander Feigl <Alexander.Feigl@gmx.de>
    @version $id$

*/

class PipeCopy : public ProcessInterface {
  Q_OBJECT
    public:
  PipeCopy(void);

  void setupPipe(void);
  bool copyPipe(const char *source,const char *dest,long int size);
  void delayedOpen(void);
  void startPipe(void);

 signals:
  void firstOutput(void);
  
 protected:
  virtual bool processStderrLine(char *linebuffer);

 private:
  static int pipecopy(int argc,char **argv);
  static bool openOut(void);
  static void cleanup(void);
};


#endif
