// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "ProgressDialog.h"
#include "ProcessInterface.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kprogress.h>
#include <keditcl.h>

#include <qpushbutton.h>
#include <qwindowdefs.h>
#include <qlayout.h>
#include <qlabel.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>

#include "ProgressDialog.moc"

ProgressDialog::ProgressDialog( QWidget *parent, const char *name,
				QString prefworktext,
                                enum ProgressType ptyp,bool modal)
  :QWidget(parent,name,modal?WType_Modal:0) {
  KConfig *config;
  QRect DefaultRect(100,100,400,200);

  attachedProcess=0;
  isModal=modal;
  oldval=-1;
  oldmax=-1;
  oldval2=-1;
  oldmax2=-1;
  oldval3=-1;
  oldmax3=-1;
  secondTotal=0;
  this->setCaption(i18n("KreateCD is working..."));
  pvlayout=new QVBoxLayout(this);

  config=kapp->config();

  pwork=new QLabel(this,"prograss label");
  pwork->setAlignment(AlignCenter);
  pwork->setMinimumSize(300,80);
  pvlayout->addWidget(pwork,10);
  pvlayout->addStretch(1);


  if (ptyp!=Progress_None) {
    plabel1=new QLabel(this);
    plabel1->setAlignment(AlignCenter);
    plabel1->setMinimumSize(plabel1->sizeHint());
    pvlayout->addWidget(plabel1,1);
    pwidget=new KProgress(KProgress::Horizontal,this,"progress dialog");
    pwidget->setMinimumSize(pwidget->sizeHint());
    pvlayout->addWidget(pwidget,1);
    pvlayout->addStretch(1);
  } else {
    pwidget=0;
    plabel1=0;
  }

  if ( (ptyp==Progress_Double) || (ptyp==Progress_Triple)) {
    plabel2=new QLabel(this);
    plabel2->setAlignment(AlignCenter);
    plabel2->setMinimumSize(plabel2->sizeHint());
    pvlayout->addWidget(plabel2,1);
    pwidget2=new KProgress(KProgress::Horizontal,this,"progress dialog");
    pwidget2->setMinimumSize(pwidget2->sizeHint());
    pvlayout->addWidget(pwidget2,1);
    pvlayout->addStretch(1);
  } else {
    pwidget2=0;
    plabel2=0;
  }

  if (ptyp==Progress_Triple) {
    plabel3=new QLabel(this);
    plabel3->setAlignment(AlignCenter);
    plabel3->setMinimumSize(plabel3->sizeHint());
    pvlayout->addWidget(plabel3,1);
    pwidget3=new KProgress(KProgress::Horizontal,this,"progress dialog");
    pwidget3->setMinimumSize(pwidget2->sizeHint());
    pvlayout->addWidget(pwidget3,1);
    pvlayout->addStretch(1);
  } else {
    pwidget3=0;
    plabel3=0;
  }

  pcancel=new QPushButton(i18n("Abort"),this,"progress cancel");
  pcancel->setFixedSize(pcancel->sizeHint());
  pvlayout->addWidget(pcancel);

  setWorkText(prefworktext);

  pvlayout->activate();

  connect(pcancel,SIGNAL(clicked()),this,SLOT(cancelPressed()));

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("ProgressDialogGeo",&DefaultRect)); 
  edit=0;
  advanced=0;
}

ProgressDialog::~ProgressDialog(void) {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("ProgressDialogGeo",SaveRect); 
}

int ProgressDialog::exec(void) {
  wasShown=isVisible();
  if ( isModal && !wasShown) show();

  kapp->enter_loop();
  if ( isModal && !wasShown) hide();
  return progressResult;
}

void ProgressDialog::done(int result) {
  progressResult=result;
  kapp->exit_loop();
}

void ProgressDialog::printStatusLine(QString line) {
  if (edit==0) return;
  edit->insertLine(line);
  edit->setCursorPosition(edit->numLines(),0,false);
}

void ProgressDialog::addStatusView(void) {
  QSize vsiz(100,50);
  QHBoxLayout *phlayout;
  KConfig *config;

  if (edit!=0) return;

  pvlayout->addStretch(5);
  phlayout=new QHBoxLayout();

  advanced=new QPushButton(this);
  advanced->setText(i18n("Advanced view >>>"));
  advanced->setMinimumSize(advanced->sizeHint());
  phlayout->addStretch(10);
  phlayout->addWidget(advanced,1);
  phlayout->addStretch(1);
  pvlayout->addLayout(phlayout,1);

  advanced->show();
  edit=new KEdit(this);
  edit->setReadOnly(true);
  vsiz.setHeight(edit->font().pointSize()*10);
  edit->setMinimumSize(vsiz);
  pvlayout->addStretch(1);
  pvlayout->addWidget(edit,60);

  config=kapp->config();
  config->setGroup("GUI");
  if (config->readBoolEntry("BurningAdvancedView",false)) {
    edit->show();
  } else {
    edit->hide();
  }

  updateGeometry();

  connect(advanced,SIGNAL(clicked()),this,SLOT(advancedView())); 
}

void ProgressDialog::cancelPressed(void) {
  emit canceled();
  if (attachedProcess!=0) attachedProcess->cancelPressed();
}

void ProgressDialog::setWorkText(QString newworktext) {
  QString progresstext;
  progresstext=i18n("KreateCD is working...");

  if (!newworktext.isEmpty()) {
    progresstext+="\n\n"+newworktext;
  }    

  pwork->setText(progresstext);
}

void ProgressDialog::setProgress(long int val,long int maxval) {
  if (pwidget==0) return;
  if (secondTotal!=0) updateSecondProgress(val);
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }

  if (val!=oldval) {
    pwidget->setValue(val);
    oldval=val;
  }
  if (maxval!=oldmax) {
    pwidget->setRange(0,maxval);
    oldmax=maxval;
  }
} 

void ProgressDialog::setProtectedProgress(long int val,long int maxval) {

  int c1=0,c2=0;
  int p1,p2;

  if (pwidget==0) return;
  if (secondTotal!=0) updateSecondProgress(val);
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }

  p1=oldval*100/oldmax;
  if (val>oldval) {
    c1=1;
    oldval=val;
  }
  if ( (maxval!=oldmax) || (val==0) ) {
    c2=1;
    c1=1;
    oldmax=maxval;
    oldval=val;
  }
  p2=oldval*100/oldmax;
  if ( (!c2) && (p2==p1) ) return;
  if (c1) {
    pwidget->setValue(val);
  }
  if (c2) {
    pwidget->setRange(0,maxval);
  }
} 

void ProgressDialog::setSecondProgress(long int val,long int maxval) {
  if (pwidget2==0) return;
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }

  if (val!=oldval2) {
    pwidget2->setValue(val);
    oldval2=val;
  }
  if (maxval!=oldmax2) {
    pwidget2->setRange(0,maxval);
    oldmax2=maxval;
  }
}

void ProgressDialog::setSecondProtectedProgress(long int val,long int maxval) {
  int c1=0,c2=0;
  int p1,p2;

  if (pwidget2==0) return;
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }


  p1=oldval2*100/oldmax2;
  if (val>oldval2) {
    c1=1;
    oldval2=val;
  }
  if ( (maxval!=oldmax2) || (val==0) ) {
    c2=1;
    oldmax2=maxval;
    c1=1;
    oldval2=val;
  }
  p2=oldval2*100/oldmax2;
  if ( (!c2) && (p2==p1) ) return;
  if (c1) {
    pwidget2->setValue(val);
  } 
  if (c2) {
    pwidget2->setRange(0,maxval);
  }
}

void ProgressDialog::setThirdProgress(long int val,long int maxval) {
  if (pwidget3==0) return;
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }
  if (val!=oldval3) {
    pwidget3->setValue(val);
    oldval3=val;
  }
  if (maxval!=oldmax3) {
    pwidget3->setRange(0,maxval);
    oldmax3=maxval;
  }
}

void ProgressDialog::setThirdProtectedProgress(long int val,long int maxval) {
  int c1=0,c2=0;
  int p1,p2;

  if (pwidget3==0) return;
  while (maxval>(2<<16)) { 
    val>>=4;
    maxval>>=4;   
  }
  p1=oldval3*100/oldmax3;
  if ( (val>oldval3) || (val==0) ) {
    c1=1;
    oldval3=val;
  }
  if (maxval!=oldmax3) {
    c2=1;
    oldmax3=maxval;
    c1=1;
    oldval3=val;
  }
  p2=oldval3*100/oldmax3;
  if ( (!c2) && (p2==p1) ) return;
  if (c1) {
    pwidget3->setValue(val);
  } 
  if (c2) {
    pwidget3->setRange(0,maxval);
  }
}

void ProgressDialog::abortDialog(int returncode) {
  done(returncode);
}

void ProgressDialog::abortCancel(void) {
  done(-1);
}

void ProgressDialog::attachProcess(ProcessInterface *proc) {
  if (attachedProcess!=0) {
    detachProcess(attachedProcess);
  }
  attachedProcess=proc;

  if (attachedProcess!=0) {
    connect(attachedProcess,SIGNAL(processTerminated(ProcessInterface *,int)),
            this,SLOT(processTerminated(ProcessInterface *,int)));
    connect(attachedProcess,SIGNAL(processDeletion(ProcessInterface *)),
            this,SLOT(detachProcess(ProcessInterface *)));
    connect(attachedProcess,SIGNAL(processAction(QString)),
            this,SLOT(setWorkText(QString)));
    connect(attachedProcess,SIGNAL(processStatus(QString)),
            this,SLOT(printStatusLine(QString)));
    connect(attachedProcess,SIGNAL(processProgress(long int,long int)),
            this,SLOT(setProtectedProgress(long int,long int)));
    connect(attachedProcess,SIGNAL(processSecondProgress(long int,long int)),
            this,SLOT(setupSecondProgress(long int,long int)));
    connect(attachedProcess,SIGNAL(processBuffer(int)),
            this,SLOT(setBuffer(int)));
  }


}

void ProgressDialog::processTerminated(ProcessInterface *proc,int rv) {
  if (proc==attachedProcess) {
    abortDialog(rv);
  }
}

void ProgressDialog::detachProcess(ProcessInterface *proc) {
  if (proc!=attachedProcess) return;
  disconnect(this,SLOT(processTerminated(ProcessInterface,*,int)));
  disconnect(this,SLOT(processDeletion(ProcessInterface,*)));
  disconnect(this,SLOT(setWorkText(QString)));
  disconnect(this,SLOT(printStatusLine(QString)));
  disconnect(this,SLOT(setProgress(long int,long int)));
  disconnect(this,SLOT(setupSecondProgress(long int,long int)));
  disconnect(this,SLOT(setBuffer(long int,long int)));
  attachedProcess=0;
}

void ProgressDialog::closeEvent(QCloseEvent *clev) {
  clev->ignore();
  cancelPressed();
}

void ProgressDialog::setBuffer(int percent) {
  setThirdProgress(percent,100);
}

void ProgressDialog::setProgressDescription(QString desc,int fifonr) {
  switch (fifonr) {
    case 1:
      if (plabel1!=0) plabel1->setText(desc);
      break;
    case 2:
      if (plabel2!=0) plabel2->setText(desc);
      break;
    case 3:
      if (plabel3!=0) plabel3->setText(desc);
      break;
    default:
      break;
  }  
}

void ProgressDialog::setupSecondProgress(long int total,long int offset) {
  secondTotal=total;
  secondOffset=offset;
}

void ProgressDialog::clearSecondProgress(void) {
  secondTotal=0;
  secondOffset=0;
}

void ProgressDialog::updateSecondProgress(long int firstval) {
  setSecondProtectedProgress(firstval+secondOffset,secondTotal);
}

void ProgressDialog::advancedView(void) {
  KConfig *config;

  edit->isHidden()?edit->show():edit->hide();
  config=kapp->config();
  config->setGroup("GUI");
  config->writeEntry("BurningAdvancedView",!edit->isHidden());
  updateGeometry();
}
