// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ProjectAdvancedWidget.h"
#include <kconfig.h>
#include <kapp.h>
#include <qlayout.h>
#include <klocale.h>
#include "ProjectAdvancedWidget.moc"
#include <qsplitter.h>
#include <klibloader.h>
#include <kservice.h>
#include <kparts/part.h>
#include <kparts/factory.h>
#include "FileTree.h"
#include "AudioFileInfo.h"
#include "AudioOptions.h"
#include <qhbox.h>
#include <qvbox.h>
#include "IsoWidget.h"
#include "AdvancedInfo.h"
#include <qtimer.h>

ProjectAdvancedWidget::ProjectAdvancedWidget(QWidget *parent, 
					   TrackListManager *TLM)
  :QWidget(parent) {
  firstInvoke=true;
  TLM_=TLM;
  trackView=0;
  QVBoxLayout *mainlayout=new QVBoxLayout(this);
  mainlayout->setAutoAdd(true);
  mainlayout->setSpacing(6);
  mainlayout->setMargin(11);
  QSplitter *sp=new QSplitter(Qt::Vertical,this);
  QSplitter *sp1=new QSplitter(sp);
  createSourceTree(sp1);

  setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
			    QSizePolicy::MinimumExpanding));

  trackViewSpace=new QHBox(sp);

  QVBox *tlvVbox=new QVBox(sp1);
  TLV=new TrackListView(tlvVbox,"Classic Track List",TLM);
  QHBox *tlvButtons= new QHBox(tlvVbox);
  connect(new QPushButton(i18n("Add empty track"),tlvButtons),SIGNAL(clicked()),TLM,SLOT(addTrack()));
  connect(new QPushButton(i18n("Remove track"),tlvButtons),SIGNAL(clicked()),TLV,SLOT(deleteTrack()));

/*  SumLabel=new QLabel("-",this);
  SumLabel->setFrameStyle(QFrame::Box|QFrame::Sunken);
  SumLabel->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
				      QSizePolicy::Fixed));
  mainlayout->addWidget(SumLabel);

					 QSizePolicy::Minimum );
  mainlayout->addItem(spacer);*/


  connect(TLM,SIGNAL(trackSumUpdated(int,QString)),this,
	  SLOT(updateTrackSum(int,QString)));
  connect(TLV,SIGNAL(selectionChangedDelayed()),this,SLOT(slot0timer()));
//  connect(TLV,SIGNAL(selectionChanged()),this,SLOT(currentTrackChanged()));
  connect(TLM,SIGNAL(needUpdate(int)),this,SLOT(slot0timer()));
  connect(TLM,SIGNAL(editWindowStateChanged()),this,SLOT(currentTrackChanged()));

  //connect(TLM,SIGNAL(ListChanged()),this,SLOT(currentTrackChanged()));
  trackView=new AdvancedInfo(trackViewSpace);
	show();
}

void ProjectAdvancedWidget::slot0timer()
{
	QTimer::singleShot(0,this,SLOT(currentTrackChanged()));
}

void ProjectAdvancedWidget::createSourceTree(QWidget *par)
{
//  KService::Ptr serv= KService::serviceByDesktopName("konq_treeview");
//  if (!serv) return;

  KLibFactory *lfactory = KLibLoader::self()->factory("libkonqlistview");
  if (lfactory)
     {
          KParts::ReadOnlyPart *dirtree = static_cast<KParts::ReadOnlyPart *>
            ((static_cast<KParts::Factory *>(lfactory))->createPart(par,"source tree",this,"source tree::part","KParts::Part",
		QStringList("MixedTree")));
	  if (dirtree) {dirtree->openURL("file:/"); return;}
     }
   FileTree *sourceTree=new FileTree(par,"sourceTree",true);
// Sourcetree initialization
  {
    QFileInfo *kfi;
    kfi=new QFileInfo("/");
    sourceTree->addDir(kfi);
    delete(kfi);
  }

}

void ProjectAdvancedWidget::updateTrackSum(int , QString duration) {
//  SumLabel->setText(i18n("Tracks in project: %1 (duration %2)")
//		    .arg(trackCount).arg(duration));
}


void ProjectAdvancedWidget::resizeEvent(QResizeEvent *rs) {
  firstInvoke=false;
  QWidget::resizeEvent(rs);
}


void ProjectAdvancedWidget::triggerUpdate()
{
  int id=TLV->getCurrentId();
	if (id!=-1) TLV->needUpdate(id);
}

void ProjectAdvancedWidget::currentTrackChanged()
{
  qDebug("changeCurrentTrack (currentTrack changed or some trackchanges where detected");
  int id=TLV->getCurrentId();


  enum CDTrack::TrackSource source=CDTrack::Source_None;
  	if (id!=-1) source=TLM_->getTrackSource(id);
  if (((source==CDTrack::Source_None) || (id==-1)) || (TLM_->openedInTrackWindow(TLM_->getTrack(id))))
  {
    if (!dynamic_cast<AdvancedInfo*>(trackView))
        {
           if (trackView) delete trackView;
           trackView=0;
           trackView=new AdvancedInfo(trackViewSpace);
	   trackView->show();
        }
    return;
  }
  enum CDTrack::TrackType type=TLM_->getTrackType(id);
  if ((type==CDTrack::Track_Audio) || (type==CDTrack::Track_AudioPreEmph)) {
    if (trackView) delete trackView;
    trackView=0;
    TLM_->getTrack(id)->getAudioFile()->validateFile();
    (trackView=new AudioOptions(trackViewSpace,0,TLM_->getTrack(id)))->show();
    connect(trackView,SIGNAL(needUpdate()),this,SLOT(triggerUpdate()));

//    connect(trackView,SIGNAL(needUpdate()),this,
  }
  else
  	{
		if (TLM_->getTrackSource(id)==CDTrack::Source_Filesystem)
		{
  			if (trackView) delete trackView;
  			trackView=0;

			trackView=new IsoWidget(trackViewSpace,false);
			((IsoWidget*)trackView)->setTrack(TLM_->getTrack(id));
			trackView->show();
			connect(trackView,SIGNAL(needUpdate()),this,SLOT(triggerUpdate()));
		}
	}
}
