// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ProjectFromDirExt.h"
#include "ProjectFromDirExt.moc"
#include "TrackListManager.h"
#include "IsoFile.h"
#include "IsoImage.h"

#include <klineedit.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <kfiledialog.h>
#include <qlabel.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <kmessagebox.h>

ProjectFromDirExt::ProjectFromDirExt(QWidget *parent):ProjectFromDirExt_skel(parent)
{
  track=0;
  dirPath->setText("");
  imgPath->setText("");
}

ProjectFromDirExt::~ProjectFromDirExt(){;}

void ProjectFromDirExt::setTLM(class TrackListManager *TLM)
{
  _TLM=TLM;
  dirPath->setText(TLM->initialPath);
  imgPath->setText(TLM->initialPath+".iso");  
  connect(imgButton,SIGNAL(clicked()),this,SLOT(openDialog()));
  connect(createImage,SIGNAL(clicked()),this,SLOT(createImg()));
  connect(_TLM,SIGNAL(clearList()),this,SLOT(clearTracks()));   
}
 
 
void ProjectFromDirExt::openDialog()
{
  QString fname=KFileDialog::getSaveFileName(QString::null,"*.iso|Iso-Image (*.iso)",(QWidget*)parent(),i18n("Choose an image name"));
  if (!fname.isEmpty())
    {
       imgPath->setText(fname);
    }
}

void ProjectFromDirExt::clearTracks()
{
  if (_TLM->shutdown) return;
  CDTrack *tmpTrack;
  tmpTrack=new CDTrack();
  tmpTrack->setTrackType(CDTrack::Track_DataMode1);
  class ISOImage *isoim;
  isoim=tmpTrack->getISOImage();

  tmpTrack->setSourceFileSystem(isoim);
  if (tmpTrack->getISOImage()==0) qDebug("getISOIMAGE == 0");
  _TLM->addTrack(tmpTrack);
  root=tmpTrack->getISOImage()->imageRoot();
  track=tmpTrack;
  parseDir();
}

void ProjectFromDirExt::parseDir()
{
  
  QDir d(dirPath->text());
  QFileInfoList FIL(*d.entryInfoList());
  if (FIL.count()!=0)
  for(QFileInfo *it=FIL.first();it!=0;it=FIL.next())
	{
		QString fname=it->fileName();
		QString fpath=it->filePath();
		if ((fname==".") || (fname=="..")) continue;
		root->addObject(new ISOFile((it->isDir())?(ISOFile::ISO_RealDir):(ISOFile::ISO_RealFile),
			&fname,&fpath));
		qDebug(fname);
		qDebug(fpath);
//		root->addObject(new ISOFile(ISOFile::ISO_RealDir,new QString("etc"),new QString("/etc")));
	}
	else
    	{
		qDebug("No dir entry or parse error");
    	}
}


void ProjectFromDirExt::createImg() {
	if (track) { 
	if (!track->validateTrack(0,imgPath->text())) {
          KMessageBox::error(0,i18n("Can't create temporary image"),QString::null); 
        }
        track->saveImage();
//Couldn't test (broken konqueror)	if (!track->exportISO(imgPath->text()))	KMessageBox::error(0,i18n("Can't create temporary image"),QString::null);

	}
}
