// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ProjectSingleDataWidget.h"
#include <kconfig.h>
#include <kapp.h>
#include <qlayout.h>
#include <klocale.h>

#include "ProjectSingleDataWidget.moc"
#include "CDTrack.h"

ProjectSingleDataWidget::ProjectSingleDataWidget(QWidget *parent, TrackListManager *TLM):QObject()
{

  IW=0;
  _TLM=TLM;
  IW=new IsoWidget(parent);
  IW->show();

  connect(_TLM,SIGNAL(clearList()),this,SLOT(clearTracks()));


}

void ProjectSingleDataWidget::clearTracks()
{
  if (_TLM->shutdown) return;
  CDTrack *tmpTrack;
  tmpTrack=new CDTrack();
  tmpTrack->setTrackType(CDTrack::Track_DataMode1);
  class ISOImage *isoim;
  isoim=tmpTrack->getISOImage();
  tmpTrack->setSourceFileSystem(isoim);
  if (tmpTrack->getISOImage()==0) qDebug("getISOIMAGE == 0");

  //break;
 
  /*
     if (isoim==0) {
    	connect(ThisTrack->getISOImage(),SIGNAL(imageChanged()),
		this,SLOT(makeImageDirty()));
      }
      ISOTreeWindow=new ISOWindow(0,0,ThisTrack->getISOImage(),ThisTrack);
      connect(ISOTreeWindow,SIGNAL(closed()),this,SLOT(closedISOTree()));
      connect(ISOTreeWindow,SIGNAL(needUpdate()),
	      this,SLOT(updateWindowContents()));
      ISOTreeWindow->show();
      connect(ISOTreeWindow,SIGNAL(imageChanged()),
	      this,SLOT(makeImageDirty()));
  */



  _TLM->addTrack(tmpTrack);
  IW->setTrack(tmpTrack);
}

void ProjectSingleDataWidget::updateTrack(CDTrack *track) {
  IW->setTrack(track);
}


ProjectSingleDataWidget::~ProjectSingleDataWidget() {
	if (IW) delete IW;
}










