// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "TOCCdrecord.h"
#include "ProgressDialog.h"
#include "appmacros.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

int TOCCdrecord::invokeTOCReader(bool readBurner) {
  int i;
  KConfig *config;
  char devline[32];
  int host,unit;

  prepareProcess();
  config=kapp->config();
  config->setGroup("SCSI");
  if (readBurner) {
    host=config->readNumEntry("SCSIWriterHost",0);
    unit=config->readNumEntry("SCSIWriterUnit",-1);
  } else {
    host=config->readNumEntry("SCSICdromHost",0);
    unit=config->readNumEntry("SCSICdromUnit",-1);
  }
  if (unit==-1) return(0);
  sprintf(devline,"dev=%d,%d,0",host,unit);

  config->setGroup("Path");
  if FREE_CDRECORD {
    *this<<config->readEntry("PathCdrecord",PATH_CDRECORD)<<"-toc"<<devline;
  } else {
    *this<<PATH_WRAPPER<<"cdrecord"<<"-toc"<<devline;
  }

  for (i=0;i<128;++i) {
    toc_lba[i]=-1;
  }

  reportAction(i18n("Scanning TOC..."));
  startProcess();
  return(1);
}


int TOCCdrecord::processCleanup(int )
{
  closeProcess();
  closeTOC();
  if (toctracks==0) return(0);
  return(1);
}

bool TOCCdrecord::processStdoutLine(char *linebuffer) {
  char *cptr,*tptr=0,*lptr=0,*aptr=0,*ctptr=0,*mptr=0,freetoc=0;
  long int track,lba,address,control,mode;

  if (strncmp("track:",linebuffer,6)!=0) return(true);
  cptr=linebuffer+6;
  while (toc_lba[freetoc]!=-1) freetoc++;
  tptr=cptr;
  while (*cptr!=0) {
    if (strncmp("lba:",cptr,4)==0) lptr=cptr+4;
    if (strncmp("adr:",cptr,4)==0) aptr=cptr+4;
    if (strncmp("control:",cptr,8)==0) ctptr=cptr+8;
    if (strncmp("mode:",cptr,5)==0) mptr=cptr+5;
    ++cptr;
  }
  if ( (lptr==0) || (aptr==0) || (ctptr==0) || (mptr==0) ) return(true);
  track=strtol(tptr,0,10);
  lba=strtol(lptr,0,10);
  address=strtol(aptr,0,10);
  control=strtol(ctptr,0,10);
  mode=strtol(mptr,0,10);
  if (freetoc!=0) {
    toc_durat[freetoc-1]=lba-toc_lba[freetoc-1];
  }
  if (track!=(freetoc+1)) return(true);
  toc_lba[freetoc]=lba;
  toc_durat[freetoc]=0;
  toc_ttype[freetoc]=CDTrack::Track_CDI;
  switch (control) {
  case 0:
    toc_ttype[freetoc]=CDTrack::Track_Audio;
    break;
  case 1:
    toc_ttype[freetoc]=CDTrack::Track_AudioPreEmph;
  case 4:
    if (mode==1) toc_ttype[freetoc]=CDTrack::Track_DataMode1;
    if (mode==2) toc_ttype[freetoc]=CDTrack::Track_DataMode2;
    break;
  }
  return(true);
}

