// KreateCD - CD recording software for the K desktop environment
//
// 1999-2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "WriteDialog.h"
#include "ConfigBurnerWidget.h"
#include "ProgressDialog.h"
#include "CDWriter.h"
#include "CDTrack.h"
#include "IsoImage.h"
#include "WriteDialog.moc"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include <qwindowdefs.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>

WriteDialog::WriteDialog( QWidget *parent, const char *name,int ntracks,CDTrack **tracks):QDialog(parent,name,true) {
  QVBoxLayout *qvlayout;
  QHBoxLayout *endbuttonlay;
  int i;
  numtracks=ntracks;
  cdtracks=tracks;
  
  disableOTF=false;
 
  if (CDWriter::singleDrive()) {
    for (i=0;i<ntracks;++i) {
      if (tracks[i]->needDualDrive()) {
        disableOTF=true;
        break;
      }
    }
  }

  for (i=1;i<ntracks;++i) {
    if (tracks[i]->getTrackSource()!=CDTrack::Source_Filesystem) continue;    
    if (tracks[i]->getISOImage()->getMSLBA()!=-1) {
      disableOTF=true;
      break;
    }
  }

  qvlayout=new QVBoxLayout(this);
  endbuttonlay=new QHBoxLayout();

  this->setCaption(i18n("Write CD"));

  QHBox *Wid1=new QHBox(this);
  Wid1->setFrameShape(QFrame::Box);
  Wid1->setFrameShadow(QFrame::Sunken);
  burnerwidget = new ConfigBurnerWidget( Wid1 , "burner",!disableOTF );
  qvlayout->addWidget( Wid1 );
  qvlayout->addStretch(1);
  qvlayout->addLayout(endbuttonlay,0);
  qvlayout->addStretch(1);
  qvlayout->setMargin(5);
  qvlayout->setSpacing(5);
  endbuttonlay->addStretch(1);
  writebutton=new QPushButton(i18n("Write CD!"),this);
  writebutton->setFixedSize(writebutton->sizeHint());
  endbuttonlay->addWidget(writebutton);
  endbuttonlay->addStretch(1);
  exitbutton=new QPushButton(i18n("Exit"),this);
  exitbutton->setFixedSize(writebutton->sizeHint());
  endbuttonlay->addWidget(exitbutton,0);
  endbuttonlay->addStretch(1);

  connect(writebutton,SIGNAL(clicked()),this,SLOT(writeCD()));
  connect(exitbutton,SIGNAL(clicked()),this,SLOT(exitDialog()));

  qvlayout->activate();
}

void WriteDialog::writeCD(void) {
  CDWriter::Fixating XFixating = burnerwidget->getFixating();
  bool Simmode = burnerwidget->getSimulation();
  bool XEject = burnerwidget->getEject();
  bool OnTheFly = burnerwidget->getOnTheFly();
  int Burnspeed = burnerwidget->getSpeed();
  CDWriter *da;
  ProgressDialog *prog;

  if (disableOTF) OnTheFly=false;

  da=new CDWriter();
  if (da==0) return;

  da->setupCD(numtracks,cdtracks,Simmode,Burnspeed,XFixating,XEject,OnTheFly);
  if (!da->checkDiskSpace()) {
    delete da;
    return;
  }
  if (!da->checkMSMismatch()) {
    delete da;
    return;
  }

  prog=new ProgressDialog(0,0,0,ProgressDialog::Progress_Triple);
  prog->setProgressDescription(i18n("Track:"));
  prog->setProgressDescription(i18n("Complete CD-R:"),2);
  prog->setProgressDescription(i18n("FIFO filled:"),3);
  prog->show();
  if (!da->prepareBurn(prog)) {
    da->cleanupBurn();
    delete prog;
    delete da;
    return;
  }

  if (disableOTF) {
    if (QMessageBox::information(0,QString::null,
      i18n("Please insert a CD-R media in your CD-Writer"),
      QMessageBox::Ok,QMessageBox::Cancel,0)!=1) {
      da->cleanupBurn();
      delete prog;
      delete da;
      return;
    }
  }

  prog->attachProcess(da);
  prog->addStatusView();
  da->burnCD();
  prog->exec();
  da->cleanupBurn();
  delete da;
  delete prog;
}

void WriteDialog::exitDialog(void) {
  this->done(0);
}
