// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#ifndef MP3IDENTIFY_INCLUDED
#define MP3IDENTIFY_INCLUDED

#include "AudioIdentify.h"

class MP3Identify : public AudioIdentify {

 protected:
  virtual int identify(void);

 private:
  bool seekHeader(int bytes=-1,bool initial=false);
  bool parseHeader(void);

  int mpegVersion;
  int mpegLayer;
  bool mpegCRC;
  int mpegBitrate;
  int mpegSample;
  bool mpegPadding;
  int mpegMode;
  int mpegExtension;
  bool mpegCopyright;
  bool mpegOriginal;
  int mpegEmphasis;

  long mpegCRCValue;
  long mpegCRCCalc;

  int mpegSlotsize;
  int mpegSamples;
  int mpegLength;
};

#endif
