/* KreateCD - CD recording software for the K desktop environment
 *
 * 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
 *
 * This file is subject to the terms and conditions of the GNU General
 * Public License.  See the file COPYING in the main directory of the
 * KreateCD distribution for more details.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <string.h>
#include <stdlib.h>

void start_app(const char *path,char **argv);
int fork_off(const char *path,char **argv);


void start_app(const char *path,char **argv) {
    char *evir[2];
    evir[0]=0;
    evir[1]=0;
    execve(path,argv+1,evir);
    exit(0);
}

int fork_off(const char *path,char **argv) {
  int fpid;
  
  fpid=fork();
  if (fpid==0) {
    start_app(path,argv);
  }  
  if (fpid==-1) {
    return(0);
  }
  return(fpid);
}

int main(int argc,char **argv) {
  if (argc<2) return(0);
  if (argv[argc]!=0) return(0);

#ifdef HAVE_CDRECORD
#ifndef CDRECORD_PRIV
  if (strcmp("cdrecord",argv[1])==0) {
    start_app(PATH_CDRECORD,argv);
  } 
#endif
#endif
  
#ifdef HAVE_MKISOFS
#ifndef MKISOFS_PRIV
  if (strcmp("mkisofs",argv[1])==0) {
    start_app(PATH_MKISOFS,argv);  
  }
#endif
#endif

#ifdef HAVE_CDDA2WAV
#ifndef CDDA2WAV_PRIV
  if (strcmp("cdda2wav",argv[1])==0) {
    start_app(PATH_CDDA2WAV,argv);  
  }
#endif
#endif

#ifdef HAVE_CDPARANOIA
#ifndef PARANOIA_PRIV
  if (strcmp("cdparanoia",argv[1])==0) {
    start_app(PATH_CDPARANOIA,argv);  
  }
#endif
#endif

#ifdef HAVE_READCD
#ifndef READCD_PRIV
  if (strcmp("readcd",argv[1])==0) {
    start_app(PATH_READCD,argv);  
  }
#endif
#endif
  return(0);
}
