/***************************************************************************
                          ProgressDialog.cpp  -  description
                             -------------------
    begin                : Die Mai 15 15:34:19 CEST 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT Includes
#include <qlayout.h>
#include <qprogressbar.h>
#include <qtimer.h>
#include <qtooltip.h>

#if QT_VERSION < 0x030100
    #include <qregexp.h>
#endif

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kpushbutton.h>
#include <krun.h>

#include <qfile.h>

// Own includes
#include "ProgressDialog.h"
#include "krenameimpl.h"
#include "undodialog.h"
#include "fileoperation.h"

#define MNU_ERROR_ID 33999
#define MNU_DONE_ID 33998

// update user interface every 1/2 second
#define TIMER_INTERVAL 500

ProgressDialog::ProgressDialog( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    resize( 400, 380 );
    setCaption( i18n("Progress") );
    setIcon( BarIcon( "krename" ) );

    ProgressDialogLayout = new QVBoxLayout( this, 11, 6 );
    Layout1 = new QHBoxLayout( 0, 0, 6 );
    QHBoxLayout* Layout2 = new QHBoxLayout( 0, 6, 6 );

    bar = new QProgressBar( this );
    bar->setProgress( 0 );

    buttonCancel = new KPushButton( i18n("&Cancel"), this );

    display = new KListView( this );
    display->addColumn( i18n("Messages") );
    display->addColumn( "sort" );
    display->setColumnWidthMode( 0, QListView::Maximum );
    display->setColumnWidthMode( 1, QListView::Manual );
    display->setColumnWidth( 1, 0 );
    display->setSorting( -1 );
    display->setUpdatesEnabled( false );
    
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );

    buttonUndo = new KPushButton( this );
    buttonUndo->setText( i18n("&Undo") );
    buttonUndo->setEnabled( false );
    
    buttonClose = new KPushButton( this );
    buttonClose->setText( i18n( "&Close" ) );
    buttonClose->setEnabled( false );

    mnuButton = new KPopupMenu( this );
    mnuButton->insertItem( i18n("Restart KRename..."), this, SLOT( restart() ));
    mnuButton->insertItem( i18n("Rename Processed Files &Again..."), this, SLOT( again() ), 0, MNU_DONE_ID );
    mnuButton->insertItem( i18n("Rename Unprocessed Files &Again..."), this, SLOT( unAgain() ), 0, MNU_ERROR_ID );
    mnuButton->insertItem( i18n("Rename All Files &Again..."), this, SLOT( allAgain() ));
    buttonRestart = new KPushButton( this );
    buttonRestart->setText( i18n( "&Rename More..." ) );
    buttonRestart->setPopup( mnuButton );
    buttonRestart->setEnabled( false );
    
    buttonOpenDest = new KPushButton( this );
    buttonOpenDest->setText( i18n("&Open Destination...") );

    Layout1->addItem( spacer );
    Layout1->addWidget( buttonUndo );
    Layout1->addWidget( buttonRestart );
    Layout1->addWidget( buttonOpenDest );
    Layout1->addWidget( buttonClose );
    Layout1->addItem( spacer );

    Layout2->addWidget( bar );
    Layout2->addWidget( buttonCancel );
    Layout2->setStretchFactor( bar, 2 );

    ProgressDialogLayout->addLayout( Layout2 );
    ProgressDialogLayout->addWidget( display );
    ProgressDialogLayout->addLayout( Layout1 );

    connect( buttonClose, SIGNAL(clicked()), this, SLOT(quitAll()));
    connect( buttonOpenDest, SIGNAL(clicked()), this, SLOT(openDest()));
    connect( buttonCancel, SIGNAL( clicked()), this, SLOT(canceled() ));
    connect( buttonUndo, SIGNAL( clicked() ), this, SLOT( undo() ) );
    
    m_count = 0;
    m_canceled = false;
    m_timer = new QTimer( this, "m_timer" );
    connect( m_timer, SIGNAL( timeout() ), this, SLOT( slotTimer() ) );
    
    hide();
}

ProgressDialog::~ProgressDialog()
{
    delete m_timer;
    delete [] renamedFiles;
}

void ProgressDialog::print( QString text, QString pixmap )
{
    if( !m_timer->isActive() )
    {
        KApplication::setOverrideCursor( Qt::waitCursor );
        m_timer->start( TIMER_INTERVAL );
    }
    
    // set an icon if we have none yet
    if( pixmap.isNull() )
        pixmap = "ok";
        
    KListViewItem* item = new KListViewItem( display, text, count() );
    item->setPixmap( 0, SmallIcon(pixmap) );
    display->insertItem( item );
}

void ProgressDialog::error( QString text )
{
    if( !m_timer->isActive() )
    {
        KApplication::setOverrideCursor( Qt::waitCursor );
        m_timer->start( TIMER_INTERVAL );
    }
    
    //TODO: simplify this (breaks i18n)
    KListViewItem* item = new KListViewItem( display, QString( i18n("Error: %1") ).arg( QString::null ) + simplify( text ), count() );
    item->setPixmap( 0, SmallIcon("cancel") );
    display->insertItem( item );
}

void ProgressDialog::warning( QString text )
{
    if( !m_timer->isActive() )
    {
        KApplication::setOverrideCursor( Qt::waitCursor );
        m_timer->start( TIMER_INTERVAL );
    }
    
    KListViewItem* item = new KListViewItem( display, QString( i18n("Warning: %1") ).arg( QString::null ) + simplify( text ), count() );
    item->setPixmap( 0, SmallIcon("idea") );
    display->insertItem( item );    
}

void ProgressDialog::quitAll()
{
    KApplication::exit(0);
}

void ProgressDialog::done( int errors, int successfull, bool allowundo )
{
    m_timer->stop();
    KApplication::restoreOverrideCursor();

    display->setUpdatesEnabled( true );
    display->setSorting( 1, true );
    display->sort();
    display->setSorting( -1 );
    display->triggerUpdate();
    display->ensureItemVisible( display->lastItem() );

    bar->setProgress( bar->totalSteps() );
    mnuButton->setItemEnabled( MNU_ERROR_ID, errors );
    mnuButton->setItemEnabled( MNU_DONE_ID, successfull );
    
    buttonClose->setEnabled( true );
    buttonRestart->setEnabled( true );
    if( allowundo )
        buttonUndo->setEnabled( true );
    buttonCancel->setEnabled( false );

    kapp->processEvents( 0 );
}

void ProgressDialog::show()
{
    QWidget::show();

    int w = kapp->desktop()->width();
    int h = kapp->desktop()->height();
    move( (w-width())/2,(h-height())/2 );
}

void ProgressDialog::restart()
{
    QWidget* krename = KRenameImpl::launch( QRect( 0, 0, 0, 0 ), KURL::List() );
    krename->show();
    close();
}

void ProgressDialog::again()
{
    KURL::List list;
    for( unsigned int i = 0; i < m_size; i++ )
        if( !renamedFiles[i].error )
            list.append( renamedFiles[i].dst );

    QWidget* krename = KRenameImpl::launch( QRect( 0, 0, 0, 0 ), list );
    krename->show();
    close();
}

void ProgressDialog::unAgain()
{
    KURL::List list;
    for( unsigned int i = 0; i < m_size; i++ )
        if( renamedFiles[i].error )
            list.append( renamedFiles[i].src );
    
    QWidget* krename = KRenameImpl::launch( QRect( 0, 0, 0, 0 ), list );
    krename->show();
    close();
}

void ProgressDialog::allAgain()
{
    KURL::List list;
    for( unsigned int i = 0; i < m_size; i++ )
        list.append( renamedFiles[i].error ? renamedFiles[i].src : renamedFiles[i].dst );
    
    QWidget* krename = KRenameImpl::launch( QRect( 0, 0, 0, 0 ), list );
    krename->show();
    close();
}

void ProgressDialog::openDest()
{
    new KRun( m_dest );
}

QString ProgressDialog::count()
{
    QString s;
    return s.sprintf( "%0*i", 7, ++m_count );
}

void ProgressDialog::setProgressTotalSteps( int t )
{
    bar->setTotalSteps( t );
}

void ProgressDialog::setProgress( int p )
{
        m_timer->start( TIMER_INTERVAL );
       
    bar->setProgress( p );
}

void ProgressDialog::canceled()
{
    warning( i18n("User pressed cancel!") );
    warning( i18n("Aborting...") );
    m_canceled = true;
}

const QString ProgressDialog::simplify( const QString & text )
{
    // make error messages fit in one line!
    QString t( text );
#if QT_VERSION >= 0x030100
    t.remove( '\n' );
#else
    t.replace( QRegExp("\n"), "" );
#endif    

    return t;
}

void ProgressDialog::undo()
{
    KURL::List list;
    FileOperation fop;
    
    m_timer->start( TIMER_INTERVAL );
    KApplication::setOverrideCursor( Qt::waitCursor );
    for( unsigned int i = 0; i < m_size; i++ )
    {
        setProgress( i );
        list.append( renamedFiles[i].src );
        if( !renamedFiles[i].error )
        {
            if( renamedFiles[i].dir ) { 
                /** handle renamed directories and their contents
                  */
                QString ddir = renamedFiles[i].dst.path();
                QString sdir = renamedFiles[i].src.path();
                for( unsigned int c = i+1; c < m_size; c++ ) {
                    QString dpath = renamedFiles[c].dst.path();
                    QString spath = renamedFiles[c].src.path();

                    if( spath.startsWith( ddir ) )
                    {
                        spath = sdir + spath.right( spath.length() - ddir.length() );
                        renamedFiles[c].src.setPath( spath );
                    }
                    
                    
                    if( dpath.startsWith( ddir ) )
                    {
                        dpath = sdir + dpath.right( dpath.length() - ddir.length() );
                        renamedFiles[c].dst.setPath( dpath );
                    }
                }
            }
            
            if(!fop.start( renamedFiles[i].dst, renamedFiles[i].src, MOVE, false ))
                error( i18n("Undo: ") + fop.error() );
        }
    }
    
    print( i18n("Undoing the renaming operation has been completed."), "undo" );
    m_timer->stop();
    KApplication::restoreOverrideCursor();
        
    QWidget* krename = KRenameImpl::launch( QRect( 0, 0, 0, 0 ), list );
    krename->show();
    close();
}

void ProgressDialog::slotTimer()
{
    kapp->processEvents( 0 );
}
