/***************************************************************************
                    lmsensordockpanel.cpp  -  description
                             -------------------
    begin                : Tue Sep 18 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qpixmap.h>

#include <kstddirs.h>
#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>

#include "lmsensordockpanel.h"

LMSensorDockPanel::LMSensorDockPanel(LMSensor *newSensor, const char *name) : KSystemTray( 0, name )
{
 strValue   = "";
 if(newSensor) {
    sensor= newSensor;
    updateConfig();
    connect( newSensor, SIGNAL(valueChanged(double)) , this, SLOT(setValue(double)) );
    connect( newSensor, SIGNAL(configChanged())      , this, SLOT(updateConfig()) );
 } else {
    sensor= 0;
    setPixmap(BarIcon("ksensorsdocked"));
 }
}

LMSensorDockPanel::~LMSensorDockPanel()
{
}

void LMSensorDockPanel::setValue(double value)
{
 strValue.sprintf("%2.0f",value);
 update();
}


void LMSensorDockPanel::updateConfig()
{
 KConfig *cfg= sensor->getConfig();
 colorAlarm = readColorAlarm (cfg,name());
 colorNormal= readColorNormal(cfg,name());
 setValue(sensor->getValue());
}

void LMSensorDockPanel::paintEvent ( QPaintEvent *e )
{
 if(sensor) {
   int w= width();
   int h= height();
   QPainter painter(this);
   QColor color= sensor->getAlarm() ? colorAlarm : colorNormal;
   QColor colorShadow= color.dark(200);
   painter.setPen(color);
   painter.drawLine(2, 2  , w-2,2  );
   painter.drawLine(2, h-3, w-2,h-3);
   painter.setPen(colorShadow);
   painter.drawLine(3, 3  , w-3,3  );
   painter.drawLine(3, h-4, w-3,h-4);
   QLcd::draw(&painter,4,6,w-6, h-12,strValue.latin1(),QLcd::drawShadow,&color,&colorShadow);
 } else {
   KSystemTray::paintEvent(e);
 }
}

void LMSensorDockPanel::mousePressEvent ( QMouseEvent *e )
{
 emit mouseEvent(e);
}

void LMSensorDockPanel::mouseReleaseEvent ( QMouseEvent *e )
{
 emit mouseEvent(e);
}


//*****************************************************************+

void LMSensorDockPanel::writeColorAlarm(KConfig *cfg, const char *name, const QColor &color)
{
 cfg->setGroup(name);
 cfg->writeEntry("colorAlarm",color);
}

void LMSensorDockPanel::writeColorNormal(KConfig *cfg, const char *name,const QColor &color)
{
 cfg->setGroup(name);
 cfg->writeEntry("colorNormal",color);
}

QColor LMSensorDockPanel::readColorAlarm(KConfig *cfg,const char *name)
{
 if(cfg) {
    cfg->setGroup(name);
    return cfg->readColorEntry("colorAlarm" , &red  );
 } else {
    return red;
 }
}

QColor LMSensorDockPanel::readColorNormal(KConfig *cfg, const char *name)
{
 if(cfg) {
    cfg->setGroup(name);
    return cfg->readColorEntry("colorNormal", &darkGreen);
 } else {
    return darkGreen;
 }
}

void LMSensorDockPanel::writeShowInDock(KConfig *cfg, const char *name, bool fShow)
{
 cfg->setGroup(name);
 cfg->writeEntry("showInDock",fShow);
}

bool LMSensorDockPanel::readShowInDock(KConfig *cfg, const char *name)
{
 if(cfg) {
    cfg->setGroup(name);
    return cfg->readBoolEntry("showInDock", false);
 } else {
    return false;
 }
}

