/***************************************************************************
                          display.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "panel.h"

Panel::Panel(QWidget *parent, const char *name ) : QFrame(parent,name)
{
 QPalette pal= palette();
 pal.setColor(QColorGroup::Background,Qt::white);
 setPalette(pal);
// setFrameStyle( QFrame::Box|QFrame::Raised);
 setFrameStyle( QFrame::Panel|QFrame::Raised);
 resize(64,64);
 //
 installEventFilter(this);
}


Panel::~Panel(){
}


// Maybe another best solution to capture childs of child widgets events ???

bool Panel::eventFilter( QObject *o , QEvent *e)
{
 emit eventReceived(e);
 return false;
}


//*****************************************************************************

bool Panel::readShow(KConfig *cfg, const char *name)
{
 if(cfg) {
   cfg->setGroup(name);
   return cfg->readBoolEntry("show",false);
 } else {
   return false;
 }
}


void Panel::writeShow(KConfig *cfg,const char *name, bool fShow)
{
 cfg->setGroup(name);
 cfg->writeEntry("show",fShow);
}
