/***************************************************************************
                          ksimus.h  -  description
                             -------------------
    begin                : Sam Dez 23 15:44:46 CET 2000
    copyright            : (C) 2000 by Rasmus Diekenbrock
    email                : ksimus@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSIMUS_H
#define KSIMUS_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// C-Includes

// QT-Includes

// KDE-Includes
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>

// Project-Includes
#include "types.h"

// Forward declaration

class KSimusDoc;
class KSimusView;
class BaseWindow;
class LogList;
class KSimEditor;
class ComponentInfo;


/**
  * The base class for KSimus application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KSimusView creates your center view, which is connected
  * to the window's Doc object.
  * KSimusApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KSimusApp : public KMainWindow
{
  Q_OBJECT

class Private;

friend class KSimusView;
friend class KSimEditor;

public:
	/** construtor of KSimusApp, calls all init functions to create the application.
		*/
	KSimusApp(QWidget* parent=0, const char* name=0);
	~KSimusApp();
	/** opens a file specified by commandline option
		*/
	void openDocumentFile(const KURL& url);
	/** returns a pointer to the current document connected to the KTMainWindow instance and is used by
		* the View class to access the document object's methods
		*/	
	KSimusDoc *getDocument() const; 	
	/** returns a pointer to the active editor
		*/	
	KSimEditor * getActiveEditor() const;
	/** returns a pointer to the log list widget
		*/	
	LogList * getLogList() const;

	/** Returns the file name of the last selceted module
		*/
	const QString & getModuleFile() const;

	/** Converts a eAppViewType into a corresponding string */
	static const char * convertViewType(eAppViewType view);
	/** Set the current view. */
	void setCurrentView(eAppViewType newView);
	/** Set the current view. */
	void setCurrentView(const char * newView);
	/** Returns the current view. */
	eAppViewType getCurrentView() const;
	/** Returns a string which describes the current view. */
	const char * getCurrentViewString() const;

protected:
	/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
		* file
		*/ 	
	void saveOptions();
	/** read general Options again and initialize all variables like the recent file list
		*/
	void readOptions();
	/** initializes the KActions of the application */
	void initActions();
	/** sets up the statusbar for the main window by initialzing a statuslabel.
		*/
	void initStatusBar();
	/** initializes the document object of the main window that is connected to the view in initView().
		* @see initView();
		*/
	void initDocument();
	/** creates the centerwidget of the KTMainWindow instance and sets it as the view
		*/
	void initView();
	/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
		* default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
		* be saved if Modified; on cancel the closeEvent is rejected.
		* @see KTMainWindow#queryClose
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryClose();
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
		* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
		* properties.
		* @see KTMainWindow#queryExit
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryExit();
	/** saves the window properties for each open window during session end to the session config file, including saving the currently
	* opened file by a temporary filename provided by KApplication.
	* @see KTMainWindow#saveProperties
	*/
	virtual void saveProperties(KConfig *_cfg);
	/** reads the session config file and restores the application's state including the last opened files and documents by reading the
		* temporary files saved by saveProperties()
		* @see KTMainWindow#readProperties
		*/
	virtual void readProperties(KConfig *_cfg);

protected slots:
	/** This function is connected to the signal currentChanged() of QTabWidget */
	void slotViewChanged(QWidget * wid);

public slots:
	/** open a new application window by creating a new instance of KSimusApp */
	void slotFileNewWindow();
	/** clears the document in the actual view to reuse it as the new document */
	void slotFileNew();
	/** open a file and load it into the document*/
	void slotFileOpen();
	/** opens a file from the recent files menu */
	void slotFileOpenRecent(const KURL& url);
	/** save a document */
	void slotFileSave();
	/** save a document by a new filename*/
	void slotFileSaveAs();
	/** asks for saving if the file is modified, then closes the actual file and window*/
	void slotFileClose();
	/** print the actual file */
	void slotFilePrint();
	/** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
		* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
		*/
	void slotFileQuit();
	/** Undo last action
	 */
	void slotEditUndo();
	/** Redo last action
	 */
	void slotEditRedo();
	/** Deletes the selcected components. */
	void slotEditDelete();
	/** put the marked text/object into the clipboard and remove
	 *	it from the document
	 */
	void slotEditCut();
	/** put the marked text/object into the clipboard
	 */
	void slotEditCopy();
	/** paste the clipboard into the document
	 */
	void slotEditPaste();
	/** Opens a file dialog for module selection. Inserts Module in sheet
	 */
	void slotEditInsertModule();
	/** toggles the toolbar
	 */
	void slotViewToolBar();
	void slotViewToggleLog();
	void slotViewHideLog();
	void slotViewToggleTree();
	void slotViewHideTree();
	void slotViewFoldTree();
	void slotViewUnfoldTree();
	void slotViewToggleCostmap();
	void slotSettingMapSize();
	void slotSettingTiming();
	void slotSettingGrid();
	void slotSettingPackageFiles();

	/** toggles the statusbar
	 */
	void slotViewStatusBar();

	void slotExecuteReset();
	void slotExecuteStart();
	void slotExecuteStop();
	void slotExecutePause();

	/** changes the statusbar contents for the standard label permanently, used to indicate current actions.
	 * @param text the text that is displayed in the statusbar
	 */
	void slotStatusMsg(const QString &text);
	/** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
	 * statusbar messages that give information about actions for toolbar icons and menuentries.
	 * @param text the text that is displayed in the statusbar
	 */
	void slotStatusHelpMsg(const QString &text);
	/** Receives the component info for inserting component and calls the function slotSelctCI()
	 * of the active editor.
	 */
	void slotSelectCI(const ComponentInfo *ci);
	void slotEditorModeChanged(int);

	void slotTestAction();

	void slotDeleteAllowed(bool);
	void slotCutAllowed(bool);
	void slotCopyAllowed(bool);
	void slotUndoAllowed(bool);
	void slotRedoAllowed(bool);
	void slotSaveAllowed(bool);

  void slotSimulationTimeChanged();

	/** Enables / Disables actions depending on current state.
		*/
	void slotSetupActions();
		
private:
	Private * m_p;

	/** the configuration object of the application */
	KConfig *config;
	/** doc represents your actual document and is created only once. It keeps
		* information such as filename and does the serialization of your files.
		*/
	KSimusDoc *doc;

	/** baseWin is the base window of KSimus. It's splitted in 3 areas.
	 */
	BaseWindow * baseWin;

	// KAction pointers to enable/disable actions
	KAction* fileNewWindow;
	KAction* fileNew;
	KAction* fileOpen;
	KRecentFilesAction* fileOpenRecent;
	KAction* fileSave;
	KAction* fileSaveAs;
	KAction* fileClose;
	KAction* filePrint;
	KAction* fileQuit;
	KAction* editUndo;
	KAction* editRedo;
	KAction* editDelete;
	KAction* editCut;
	KAction* editCopy;
	KAction* editPaste;
	KAction* editInsertModule;
	KToggleAction* viewToolBar;
	KToggleAction* viewStatusBar;
	KToggleAction* viewLogView;
	KToggleAction* viewTreeView;
	KAction* viewTreeFold;
	KAction* viewTreeUnfold;
	KToggleAction* viewCostmap;
	KAction* settingMapSize;
	KAction* settingTiming;
	KAction* settingGrid;
	KAction* settingPackageFiles;
	
	KAction* executeReset;
	KAction* executeStart;
	KAction* executeStop;
	KToggleAction* executePause;

	KAction* testAction;
	
	bool m_deleteAllowed;
	bool m_cutAllowed;
	bool m_copyAllowed;
	bool m_pastAllowed;
	bool m_undoAllowed;
	bool m_redoAllowed;
	bool m_saveAllowed;

private slots:

signals:
	void signalSelectCI(const ComponentInfo *ci);
	void signalViewChanged(eAppViewType currentView);
};

class KSimusAppList : public QList<KSimusApp> {};

#endif // KSIMUS_H
