/*
   ksmp3play - Curses-based MP3 player

   Copyright (C) 2001 Karl Soderstrom

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef _KSMP3PLAY_HEADER__
#define _KSMP3PLAY_HEADER__
#include <stdio.h>
#include <curses.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <smpeg/smpeg.h>
#ifdef __linux__
#include <getopt.h>
#else
struct option
{
  char *name;
  int has_arg;
  int *flag;
  int val;
};
# define no_argument 0
# define required_argument 1
# define optional_argument 2
#endif
#define BUFLEN 200
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <keybindings.h>

struct PlayList
{
  char file[256];
  char mp3file[256];
  int time;
  int rate;
  int vol;
  char title[31];
  char artist[31];
  char type[31];
  char year[5];
  char etc[31];
  Uint32 size;
  unsigned char genre;
}
play[1000];

static struct option const long_options[] = {
  {"help", no_argument, 0, 'h'},
  {"version", no_argument, 0, 'v'},
  {"loop", optional_argument, 0, 'l'},
  {"random", optional_argument, 0, 'r'},
  {"title", optional_argument, 0, 't'},
  {"delay", required_argument, 0, 'd'},
  {"rmethod", required_argument, 0, 'm'},
  {"playlist", 1, 0, 'p'},
  {NULL, 0, NULL, 0}
};

int num_songs, pagetop, vol, defaultvol, q, is_paused, playlist_changes,
  num_randoms, random_playlist[100000], selected, random_play, repeat_play,
  current_song, playlist_sort, xterm_title, delay_between_songs,
  random_method, getting_times;
unsigned long total_time, total_size;
short current_char;
char ks3playlist[100], *term, searchfor[27];
FILE *stderrfp;
SMPEG_Info mp3_info;
SMPEG *mpeg;
WINDOW *top;
WINDOW *bottom;
WINDOW *full;

void end_program ();
void show_playlist ();
void show_top_win (float current_time);
void get_playlist_times (int q);
void show_help (int *bindings);
void mp3_seek (int key);
void init_mp3_screen ();
void parse_config ();
void repaint ();
void load_playlist (char *argv);
void getid3info (char mp3[256], char *mp3title, char *mp3artist,
		 char *mp3type, char *mp3year, char *mp3etc, char *mp3genre);
int search_header (FILE * fp);
int delete_song (int song);
int play_mp3 (struct PlayList mp3, int *bindings);
int decode_switches (int argc, char **argv);
int get_val (char *val);
int is_bind (char *var);
int show_ks3playlist_win ();
int confirm (char statement[100], char question[100]);
void usage (int status);
void show_search_win ();
void write_playlist ();
void generate_random_playlist ();
void show_id3tag_win ();
void show_filebrowser ();
void sort_playlist (int what);
char *stristr (const char *String, const char *Pattern);
int sort_playlist_rate (const struct PlayList *c1, const struct PlayList *c2);
int sort_playlist_time (const struct PlayList *c1, const struct PlayList *c2);
int sort_playlist_artist (const struct PlayList *c1,
			  const struct PlayList *c2);
int sort_playlist_title (const struct PlayList *c1,
			 const struct PlayList *c2);
int sort_playlist_rate_rev (const struct PlayList *c1,
			    const struct PlayList *c2);
int sort_playlist_time_rev (const struct PlayList *c1,
			    const struct PlayList *c2);
int sort_playlist_artist_rev (const struct PlayList *c1,
			      const struct PlayList *c2);
int sort_playlist_title_rev (const struct PlayList *c1,
			     const struct PlayList *c2);
int writeID3 (char mp3[256], char *mp3title, char *mp3artist);
int tcp_open (char *address, int port);
int http_open (char *arg);

#endif
