/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CACHE_H
#define CACHE_H

#include <qstring.h>
#include <qsize.h>
#include <qdir.h>

#include "scaler.h"

class Cache
{
  private:
    QString mTheme;
    QString mThemeEngine;
    QDir mCacheDir;
  
    Scaler* mScaler;

    void createCacheDir();
    void writeInfoFile(QString& file);
    bool isInSync(QString& file);

    QString getFile(QString file);

  public:
    Cache(Scaler* scaler, const QString& mThemeEngine, const QString& theme);
    QImage* cacheFile(const QString& file);
};

#endif
