/***************************************************************************
                          qplotdialog.cpp  -  description
                             -------------------
    begin                : Sat Aug 25 2001
    copyright            : (C) 2001 by Pascal Brachet
    email                : pascal.brachet@free.fr
    adaptation of the Xgfe program: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qplotdialog.h"
#include <qlabel.h>
#include <qmenubar.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qframe.h>
#include <klocale.h>
#include <kfiledialog.h>

Qplotdialog::Qplotdialog(QWidget *parent, const char *name ) :QDialog(parent,name,true)

{
  gnuInt = new gnuInterface;

  // setup gnuplot interface

  gnuRC = gnuInt->openGnuplot();

  if (gnuRC == NULL) // trouble opening gnuplot
  {
    QMessageBox::critical(0, "Qplotmaker",
                          "Could not open pipe to Gnuplot!\n"
                          "Application will now exit");
  }
  // end setup of gnuplot

	filenameCB = new QCheckBox( this, "CheckBox_1" );
	filenameCB->setGeometry( QRect( 10, 40, 80, 20 ) );
	filenameCB->setText( "Data File :" );


  filenameEdit = new QLineEdit( this, "LineEdit_23" );
	filenameEdit->setGeometry( QRect( 100, 40, 100, 20 ) );
	filenameEdit->setText( "none" );
	filenameEdit->setMaxLength( 32767 );


	QPushButton* PushButton_6;
	PushButton_6 = new QPushButton( this, "PushButton_6" );
	PushButton_6->setGeometry( QRect( 210, 37, 102, 26 ) );
  connect( PushButton_6, SIGNAL(clicked()), this, SLOT(dataFileOpen()) );
	PushButton_6->setText( "Open" );


	multiFileCheckbox = new QCheckBox( this, "CheckBox_3" );
	multiFileCheckbox->setGeometry( QRect( 10, 70, 150, 20 ) );
	multiFileCheckbox->setText( "Multiple Data Files" );


	QPushButton* PushButton_4;
	PushButton_4 = new QPushButton( this, "PushButton_4" );
	PushButton_4->setGeometry( QRect( 210, 67, 102, 26 ) );
    connect( PushButton_4, SIGNAL(clicked()), this, SLOT(getMultiFile()) );
	PushButton_4->setText( "Define" );

	functionCB = new QCheckBox( this, "CheckBox_2" );
	functionCB->setGeometry( QRect( 10, 100, 80, 20 ) );
	functionCB->setText( "Function" );


	functionEdit = new QLineEdit( this, "LineEdit_1" );
	functionEdit->setGeometry( QRect( 100, 100, 290, 20 ) );
	functionEdit->setText( "" );
	functionEdit->setMaxLength( 32767 );

	multiFuncCheckbox = new QCheckBox( this, "CheckBox_4" );
	multiFuncCheckbox->setGeometry( QRect( 10, 130, 150, 20 ) );
	multiFuncCheckbox->setText( "Multiple Functions" );


	QPushButton* PushButton_5;
	PushButton_5 = new QPushButton( this, "PushButton_5" );
	PushButton_5->setGeometry( QRect( 210, 127, 102, 26 ) );
  connect( PushButton_5, SIGNAL(clicked()), this, SLOT(getMultiFunction()) );
	PushButton_5->setText( "Define" );


    Line1 = new QFrame( this, "Line1" );
    Line1->setGeometry( QRect( 10, 160, 405, 4 ) );
    Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );


  QLabel* Label_4;
	Label_4 = new QLabel( this, "Label_4" );
	Label_4->setGeometry( QRect( 10, 170, 70, 20 ) );
	Label_4->setText( "Variable X:" );



	varX = new QLineEdit( this, "LineEdit_2" );
	varX->setGeometry( QRect( 90, 170, 40, 20 ) );
	varX->setText( "" );
	varX->setMaxLength( 32767 );



	QLabel* Label_5;
	Label_5 = new QLabel( this, "Label_5" );
	Label_5->setGeometry( QRect( 150, 170, 70, 20 ) );
	Label_5->setText( "Start:" );


	xStart = new QLineEdit( this, "LineEdit_3" );
	xStart->setGeometry( QRect( 200, 170, 70, 20 ) );
	xStart->setText( "" );
	xStart->setMaxLength( 32767 );



	QLabel* Label_6;
	Label_6 = new QLabel( this, "Label_6" );
	Label_6->setGeometry( QRect( 290, 170, 40, 20 ) );
	Label_6->setText( "End:" );


	xEnd = new QLineEdit( this, "LineEdit_4" );
	xEnd->setGeometry( QRect( 340, 170, 70, 20 ) );
	xEnd->setText( "" );
	xEnd->setMaxLength( 32767 );



	QLabel* Label_10;
	Label_10 = new QLabel( this, "Label_10" );
	Label_10->setGeometry( QRect( 10, 200, 70, 20 ) );
	Label_10->setText( "Variable Y:" );



	varY = new QLineEdit( this, "LineEdit_8" );
	varY->setGeometry( QRect( 90, 200, 40, 20 ) );
	varY->setText( "" );
	varY->setMaxLength( 32767 );



	QLabel* Label_12;
	Label_12 = new QLabel( this, "Label_12" );
	Label_12->setGeometry( QRect( 150, 230, 40, 20 ) );
	Label_12->setText( "Start:" );



	yStart = new QLineEdit( this, "LineEdit_9" );
	yStart->setGeometry( QRect( 200, 200, 70, 20 ) );
	yStart->setText( "" );
	yStart->setMaxLength( 32767 );



	QLabel* Label_13;
	Label_13 = new QLabel( this, "Label_13" );
	Label_13->setGeometry( QRect( 290, 230, 40, 20 ) );
	Label_13->setText( "End:" );



	yEnd = new QLineEdit( this, "LineEdit_10" );
	yEnd->setGeometry( QRect( 340, 200, 70, 20 ) );
	yEnd->setText( "" );
	yEnd->setMaxLength( 32767 );


	QLabel* Label_14;
	Label_14 = new QLabel( this, "Label_14" );
	Label_14->setGeometry( QRect( 10, 230, 70, 20 ) );
	Label_14->setText( "Variable Z:" );



	QLabel* Label_15;
	Label_15 = new QLabel( this, "Label_15" );
	Label_15->setGeometry( QRect( 150, 200, 40, 20 ) );
	Label_15->setText( "Start:" );



	zStart = new QLineEdit( this, "LineEdit_12" );
	zStart->setGeometry( QRect( 200, 230, 70, 20 ) );
	zStart->setText( "" );
	zStart->setMaxLength( 32767 );



	QLabel* Label_16;
	Label_16 = new QLabel( this, "Label_16" );
	Label_16->setGeometry( QRect( 290, 200, 40, 20 ) );
	Label_16->setText( "End:" );



	zEnd = new QLineEdit( this, "LineEdit_13" );
	zEnd->setGeometry( QRect( 340, 230, 70, 20 ) );
	zEnd->setText( "" );
	zEnd->setMaxLength( 32767 );


    Line2 = new QFrame( this, "Line2" );
    Line2->setGeometry( QRect( 10, 260, 405, 4 ) );
    Line2->setFrameStyle( QFrame::HLine | QFrame::Sunken );



    QLabel* Label_22;
	Label_22 = new QLabel( this, "Label_20" );
	Label_22->setGeometry( QRect( 300, 270, 40, 20 ) );
	Label_22->setText( "xoff" );


    QLabel* Label_23;
	Label_23 = new QLabel( this, "Label_23" );
	Label_23->setGeometry( QRect( 370, 270, 40, 20 ) );
	Label_23->setText( "yoff" );



	QLabel* Label_7;
	Label_7 = new QLabel( this, "Label_7" );
	Label_7->setGeometry( QRect( 10, 300, 61, 20 ) );
	Label_7->setText( "X Label:" );


	xLabel = new QLineEdit( this, "LineEdit_7" );
	xLabel->setGeometry( QRect( 90, 300, 190, 20 ) );
	xLabel->setText( "" );
	xLabel->setMaxLength( 32767 );


    XLabelOffset_X = new QLineEdit( this, "LineEdit_15" );
	XLabelOffset_X->setGeometry( QRect( 290, 300, 50, 20 ) );
	XLabelOffset_X->setText( "" );
	XLabelOffset_X->setMaxLength( 32767 );



	XLabelOffset_Y = new QLineEdit( this, "LineEdit_16" );
	XLabelOffset_Y->setGeometry( QRect( 360, 300, 50, 20 ) );
	XLabelOffset_Y->setText( "" );
	XLabelOffset_Y->setMaxLength( 32767 );



	QLabel* Label_8;
	Label_8 = new QLabel( this, "Label_8" );
	Label_8->setGeometry( QRect( 10, 330, 61, 20 ) );
	Label_8->setText( "Y Label:" );



	yLabel = new QLineEdit( this, "LineEdit_6" );
	yLabel->setGeometry( QRect( 90, 330, 190, 20 ) );
	yLabel->setText( "" );
	yLabel->setMaxLength( 32767 );



	YLabelOffset_X = new QLineEdit( this, "LineEdit_17" );
	YLabelOffset_X->setGeometry( QRect( 290, 330, 50, 20 ) );
	YLabelOffset_X->setText( "" );
	YLabelOffset_X->setMaxLength( 32767 );


	YLabelOffset_Y = new QLineEdit( this, "LineEdit_18" );
	YLabelOffset_Y->setGeometry( QRect( 360, 330, 50, 20 ) );
	YLabelOffset_Y->setText( "" );
	YLabelOffset_Y->setMaxLength( 32767 );


	QLabel* Label_9;
	Label_9 = new QLabel( this, "Label_9" );
	Label_9->setGeometry( QRect( 10, 360, 61, 20 ) );
	Label_9->setText( "Z Label:" );



  zLabel = new QLineEdit( this, "LineEdit_5" );
	zLabel->setGeometry( QRect( 90, 360, 190, 20 ) );
	zLabel->setText( "" );
	zLabel->setMaxLength( 32767 );


	ZLabelOffset_X = new QLineEdit( this, "LineEdit_19" );
	ZLabelOffset_X->setGeometry( QRect( 290, 360, 50, 20 ) );
	ZLabelOffset_X->setText( "" );
	ZLabelOffset_X->setMaxLength( 32767 );



	ZLabelOffset_Y = new QLineEdit( this, "LineEdit_20" );
	ZLabelOffset_Y->setGeometry( QRect( 360, 360, 50, 20 ) );
	ZLabelOffset_Y->setText( "" );
	ZLabelOffset_Y->setMaxLength( 32767 );



    QLabel* Label_21;
	Label_21 = new QLabel( this, "Label_21" );
	Label_21->setGeometry( QRect( 10, 390, 61, 20 ) );
	Label_21->setText( "Title:" );


	titleLabel = new QLineEdit( this, "LineEdit_14" );
	titleLabel->setGeometry( QRect( 90, 390, 190, 20 ) );
	titleLabel->setText( "" );
	titleLabel->setMaxLength( 32767 );


    titleOffset_X = new QLineEdit( this, "LineEdit_21" );
	titleOffset_X->setGeometry( QRect( 290, 390, 50, 20 ) );
	titleOffset_X->setText( "" );
	titleOffset_X->setMaxLength( 32767 );


	titleOffset_Y = new QLineEdit( this, "LineEdit_22" );
	titleOffset_Y->setGeometry( QRect( 360, 390, 50, 20 ) );
	titleOffset_Y->setText( "" );
	titleOffset_Y->setMaxLength( 32767 );

  QLabel* Label_19;
  Label_19 = new QLabel( this, "Label_19" );
  Label_19->setGeometry( QRect( 10, 420, 50, 20 ) );
  Label_19->setText( "Terminal:" );


  termLabel = new QLabel( this, "Label_20" );
  termLabel->setGeometry( QRect( 70, 420, 60, 20 ) );
  termLabel->setText( "x11" );


  QLabel* Label_17;
  Label_17 = new QLabel( this, "Label_17" );
  Label_17->setGeometry( QRect( 140, 420, 40, 20 ) );
  Label_17->setText( "Output:" );


  outputLabel = new QLabel( this, "Label_18" );
  outputLabel->setGeometry( QRect( 190, 420, 230, 20 ) );
  outputLabel->setText( "stdout" );


	QPushButton* PushButton_7;
	PushButton_7 = new QPushButton( this, "PushButton_7" );
	PushButton_7->setGeometry( QRect( 10, 447, 102, 26 ) );
	PushButton_7->setText( "Output File" );
  connect( PushButton_7, SIGNAL(clicked()), this, SLOT(getOutput()) );

 	QPushButton* PushButton_8;
	PushButton_8 = new QPushButton( this, "PushButton_8" );
	PushButton_8->setGeometry( QRect( 125, 447, 102, 26 ) );
	PushButton_8->setText( "Reset Output" );
  connect( PushButton_8, SIGNAL(clicked()), this, SLOT(resetOutput()) );


 	QPushButton* PushButton_9;
	PushButton_9 = new QPushButton( this, "PushButton_9" );
	PushButton_9->setGeometry( QRect( 240, 447, 170, 26 ) );
	PushButton_9->setText( "Add Gnuplot Commands" );
  connect( PushButton_9, SIGNAL(clicked()), this, SLOT(rawGnuInput()) );


    Line3 = new QFrame( this, "Line3" );
    Line3->setGeometry( QRect( 10, 480, 405, 4 ) );
    Line3->setFrameStyle( QFrame::HLine | QFrame::Sunken );


	QPushButton* PushButton_1;
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	PushButton_1->setGeometry( QRect( 10, 490, 102, 26 ) );
	PushButton_1->setText( "Plot" );
    PushButton_1->setDefault(TRUE);
    connect( PushButton_1, SIGNAL(clicked()), this, SLOT(plot()) );

	QPushButton* PushButton_2;
	PushButton_2 = new QPushButton( this, "PushButton_2" );
	PushButton_2->setGeometry( QRect( 160, 490, 102, 26 ) );
	PushButton_2->setText( "Replot" );
    connect(PushButton_2, SIGNAL(clicked()), this, SLOT(replot()));


	QPushButton* PushButton_3;
	PushButton_3 = new QPushButton( this, "PushButton_3" );
	PushButton_3->setGeometry( QRect( 310, 490, 102, 26 ) );
    connect( PushButton_3, SIGNAL(clicked()), this, SLOT(xgfeQuit()) );
	PushButton_3->setText( "Quit" );

// create menubar

  MenuBar = new KMenuBar(this);

    // file menu
    file = new QPopupMenu;
    file->insertItem("&Save Gnuplot", this, SLOT(save()));
    file->insertItem("&Load Gnuplot", this, SLOT(load()));
    file->insertSeparator();
    file->insertItem("S&ave Xgfe", this, SLOT(saveXgfe()));
    file->insertItem("Loa&d Xgfe", this, SLOT(loadXgfe()));
    file->insertSeparator();
    file->insertItem("&Quit", this, SLOT(xgfeQuit()));

    // file plotting style popup menu
    fileStyle = new QPopupMenu;
    file_p_id = fileStyle->insertItem("&Points", this, SLOT(setFilePoints()));
    file_l_id = fileStyle->insertItem("&Lines", this, SLOT(setFileLines()));
    file_lp_id = fileStyle->insertItem("Li&nespoints", this, SLOT(setFileLinesPoints()));
    file_i_id = fileStyle->insertItem("&Impulses", this, SLOT(setFileImpulses()));
    file_d_id = fileStyle->insertItem("&Dots", this, SLOT(setFileDots()));
    file_s_id = fileStyle->insertItem("S&teps", this, SLOT(setFileSteps()));
    file_fs_id = fileStyle->insertItem("&Fsteps", this, SLOT(setFileFsteps()));
    file_hs_id = fileStyle->insertItem("&Histeps", this, SLOT(setFileHisteps()));
    file_eb_id = fileStyle->insertItem("&Errorbars", this, SLOT(setFileErrorbars()));
    file_xeb_id = fileStyle->insertItem("&Xerrorbars", this, SLOT(setFileXerrorbars()));
    file_yeb_id = fileStyle->insertItem("&Yerrorbars", this, SLOT(setFileYerrorbars()));
    file_xyeb_id = fileStyle->insertItem("Xye&rrorbars", this, SLOT(setFileXyerrorbars()));
    file_b_id = fileStyle->insertItem("&Boxes", this, SLOT(setFileBoxes()));
    file_be_id = fileStyle->insertItem("B&oxerrorbars", this, SLOT(setFileBoxerrorbars()));
    file_bxye_id = fileStyle->insertItem("Boxxyerrorbar&s", this, SLOT(setFileBoxxyerrorbars()));
    file_fin_id = fileStyle->insertItem("Fin&ancebars", this, SLOT(setFileFinancebars()));
    file_cs_id = fileStyle->insertItem("&Candlesticks", this, SLOT(setFileCandlesticks()));
    fileStyle->setCheckable(TRUE);
    fileStyle->setItemChecked(file_p_id, TRUE);

    // function plotting style popup menu
    funcStyle = new QPopupMenu;
    func_p_id = funcStyle->insertItem("&Points", this, SLOT(setFuncPoints()));
    func_l_id = funcStyle->insertItem("&Lines", this, SLOT(setFuncLines()));
    func_lp_id = funcStyle->insertItem("Li&nespoints", this, SLOT(setFuncLinesPoints()));
    func_i_id = funcStyle->insertItem("&Impulses", this, SLOT(setFuncImpulses()));
    func_d_id = funcStyle->insertItem("&Dots", this, SLOT(setFuncDots()));
    func_s_id = funcStyle->insertItem("S&teps", this, SLOT(setFuncSteps()));
    func_eb_id = funcStyle->insertItem("&Errorbars", this, SLOT(setFuncErrorbars()));
    func_b_id = funcStyle->insertItem("&Boxes", this, SLOT(setFuncBoxes()));
    funcStyle->setCheckable(TRUE);
    funcStyle->setItemChecked(func_l_id, TRUE);

    // file plotting type menu
    filePlotType = new QPopupMenu();
    file2d_id = filePlotType->insertItem("&2D", this, SLOT(setFilePlotType2d()));
    file3d_id = filePlotType->insertItem("&3D", this, SLOT(setFilePlotType3d()));
    filePlotType->setCheckable(TRUE);
    filePlotType->setItemChecked(file2d_id, TRUE);

    // function plotting type menu
    funcPlotType = new QPopupMenu();
    func2d_id = funcPlotType->insertItem("&2D", this, SLOT(setFuncPlotType2d()));
    func3d_id = funcPlotType->insertItem("&3D", this, SLOT(setFuncPlotType3d()));
    funcPlotType->setCheckable(TRUE);
    funcPlotType->setItemChecked(func2d_id, TRUE);


    // terminal menu
    terminals = new QPopupMenu;
    bfig_t_id = terminals->insertItem("&bfig", this, SLOT(setTermBfig()));
    corel_t_id = terminals->insertItem("&corel", this, SLOT(setTermCorel()));
    dxf_t_id = terminals->insertItem("&dxf", this, SLOT(setTermDxf()));
    eepic_t_id = terminals->insertItem("&eepic", this, SLOT(setTermEepic()));
    emtex_t_id = terminals->insertItem("e&mtex", this, SLOT(setTermEmtex()));
    fig_t_id = terminals->insertItem("&fig", this, SLOT(setTermFig()));
    latex_t_id = terminals->insertItem("&latex", this, SLOT(setTermLatex()));
    pbm_t_id = terminals->insertItem("&pbm", this, SLOT(setTermPbm()));
    ps_t_id = terminals->insertItem("p&ostscript", this, SLOT(setTermPostscript()));
    pslatex_t_id = terminals->insertItem("psl&atex", this, SLOT(setTermPslatex()));
    pstricks_t_id = terminals->insertItem("pstric&ks", this, SLOT(setTermPstricks()));
    table_t_id = terminals->insertItem("&table", this, SLOT(setTermTable()));
    texdraw_t_id = terminals->insertItem("texdra&w", this, SLOT(setTermTexdraw()));
    tgif_t_id = terminals->insertItem("t&gif", this, SLOT(setTermTgif()));
    tpic_t_id = terminals->insertItem("tp&ic", this, SLOT(setTermTpic()));
    x11_t_id = terminals->insertItem("&x11", this, SLOT(setTermX11()));
    terminals->setCheckable(TRUE);
    terminals->setItemChecked(x11_t_id, TRUE);

    output = ""; // initialize output to empty (stdout)

    // datafile menu
    QPopupMenu* datafileOpMenu = new QPopupMenu;
    datafileOpMenu->insertItem("&Type (2D/3D)", filePlotType);
    datafileOpMenu->insertItem("&Style", fileStyle);
    datafileOpMenu->insertItem("&Legend Title",this, SLOT(setFileLegendTitle()));
    datafileOpMenu->insertItem("&Modifiers", this, SLOT(getFileOptions()) );
    datafileOpMenu->insertItem("&Filtering", this, SLOT(setFileFilter()));

    // functions menu
    QPopupMenu* funcOpMenu = new QPopupMenu;
    funcOpMenu->insertItem("&Type (2D/3D)",funcPlotType);
    funcOpMenu->insertItem("&Style",funcStyle );
    funcOpMenu->insertItem("&Legend Title", this, SLOT(setFuncLegendTitle()));

    d3Menu = new QPopupMenu;
    d3Menu->insertItem("&Rotation", this, SLOT(getRotation()));
    d3Menu->insertItem("&Tics Level", this, SLOT(getTicsLevel()));
    d3HiddenLine_id = d3Menu->insertItem("&Hidden Line Removal", this,SLOT(set3dHiddenLine()));
    d3Menu->insertItem("&Isolines", this, SLOT(setIsolines()));
    d3Menu->setCheckable(TRUE);

    // option menu
    options = new QPopupMenu;
    options->insertSeparator();
    options->insertItem("Plot S&ize", this, SLOT(setPlotSize()));
    options->insertItem("Reset Si&ze", this, SLOT(resetSize()));
    options->insertItem("&Legend", this, SLOT(getLegendOps()));
    options->insertItem("Lo&g Scale", this, SLOT(setLogScaleOptions()));
    options->insertItem("&Bar Size", this, SLOT(setBarOptions()));
    options->insertItem("Reset B&ar Size", this, SLOT(resetBarOptions()));
    options->insertItem("Box &Width", this, SLOT(setBoxWidthOption()));
    options->insertItem("Reset Box Wi&dth", this, SLOT(resetBoxWidthOption()));
    options->insertItem("Ti&cs", this, SLOT(setTicsOptions()));
    options->insertItem("&Curve Fitting", this, SLOT(getCurveFit()));

    // help menu
    QPopupMenu* help = new QPopupMenu;
    help->insertItem("About", this, SLOT(showAbout()));

    MenuBar->insertItem("&File", file);
    MenuBar->insertItem("&Terminal", terminals);
    MenuBar->insertItem("&Datafile", datafileOpMenu);
    MenuBar->insertItem("F&unction", funcOpMenu);
    MenuBar->insertItem("3D&Plots", d3Menu);
    MenuBar->insertItem("&Options", options);
    MenuBar->insertItem("&About",help);
    MenuBar->show();

    resize( 425, 525 );



}
Qplotdialog::~Qplotdialog(){
}
void Qplotdialog::plot()
{
}

void Qplotdialog::replot()
{
}

void Qplotdialog::dataFileOpen()
{
}

void Qplotdialog::save()
{
}

void Qplotdialog::load()
{
}

void Qplotdialog::saveXgfe()
{
}

void Qplotdialog::loadXgfe()
{
}

void Qplotdialog::xgfeQuit()
{
}

void Qplotdialog::setFilePoints()
{
}

void Qplotdialog::setFileLines()
{
}

void Qplotdialog::setFileLinesPoints()
{
}

void Qplotdialog::setFileImpulses()
{
}

void Qplotdialog::setFileDots()
{
}

void Qplotdialog::setFileSteps()
{
}

void Qplotdialog::setFileFsteps()
{
}

void Qplotdialog::setFileHisteps()
{
}

void Qplotdialog::setFileErrorbars()
{
}

void Qplotdialog::setFileXerrorbars()
{
}

void Qplotdialog::setFileYerrorbars()
{
}

void Qplotdialog::setFileXyerrorbars()
{
}

void Qplotdialog::setFileBoxes()
{
}

void Qplotdialog::setFileBoxerrorbars()
{
}

void Qplotdialog::setFileBoxxyerrorbars()
{
}

void Qplotdialog::setFileFinancebars()
{
}

void Qplotdialog::setFileCandlesticks()
{
}

void Qplotdialog::setFuncPoints()
{
}

void Qplotdialog::setFuncLines()
{
}

void Qplotdialog::setFuncLinesPoints()
{
}

void Qplotdialog::setFuncImpulses()
{
}

void Qplotdialog::setFuncDots()
{
}

void Qplotdialog::setFuncSteps()
{
}

void Qplotdialog::setFuncErrorbars()
{
}

void Qplotdialog::setFuncBoxes()
{
}

void Qplotdialog::setFilePlotType2d()
{
}

void Qplotdialog::setFilePlotType3d()
{
}

void Qplotdialog::setFuncPlotType2d()
{
}

void Qplotdialog::setFuncPlotType3d()
{
}

void Qplotdialog::setTermBfig()
{
}

void Qplotdialog::setTermCorel()
{
}

void Qplotdialog::setTermDxf()
{
}

void Qplotdialog::setTermEepic()
{
}

void Qplotdialog::setTermEmtex()
{
}

void Qplotdialog::setTermFig()
{
}

void Qplotdialog::setTermLatex()
{
}

void Qplotdialog::setTermPbm()
{
}

void Qplotdialog::setTermPostscript()
{
}

void Qplotdialog::setTermPslatex()
{
}

void Qplotdialog::setTermPstricks()
{
}

void Qplotdialog::setTermTable()
{
}

void Qplotdialog::setTermTexdraw()
{
}

void Qplotdialog::setTermTgif()
{
}

void Qplotdialog::setTermTpic()
{
}

void Qplotdialog::setTermX11()
{
}

void Qplotdialog::getOutput()
{
  string temp;
  QString f = KFileDialog::getSaveFileName(QDir::currentDirPath(), "",this, i18n("Save File")); // get filename

  if (!f.isEmpty())
  {
    temp = f;
    gnuInt->setOutput(temp);
    outputLabel->setText(f);
  }
}

void Qplotdialog::resetOutput()
{
  gnuInt->setOutput(""); // reset output to empty (stdout)
  outputLabel->setText("stdout");
}

void Qplotdialog::setPlotSize()
{
}

void Qplotdialog::resetSize()
{
  gnuInt->setHorizSize("");
  gnuInt->setVertSize("");
}

void Qplotdialog::showAbout()
{
  QMessageBox::information(0, "About","Gnuplot Front End for Ktexmaker2\n"
                           "Special version of the Xgfe program created by David Ishee\n");

}


void Qplotdialog::rawGnuInput()
{
}

void Qplotdialog::getFileOptions()
{
}

void Qplotdialog::getLegendOps()
{
}

void Qplotdialog::getMultiFile()
{
}

void Qplotdialog::getMultiFunction()
{
}

void Qplotdialog::setFileLegendTitle()
{
}

void Qplotdialog::setFuncLegendTitle()
{
}

void Qplotdialog::setLogScaleOptions()
{
}

void Qplotdialog::setFileFilter()
{
}

void Qplotdialog::setBarOptions()
{
}

void Qplotdialog::resetBarOptions()
{
}

void Qplotdialog::getCurveFit()
{
}

void Qplotdialog::setBoxWidthOption()
{
}

void Qplotdialog::resetBoxWidthOption()
{
}

void Qplotdialog::setTicsOptions()
{
}

void Qplotdialog::getRotation()
{
}


void Qplotdialog::getTicsLevel()
{
}

void Qplotdialog::set3dHiddenLine()
{
}

void Qplotdialog::setIsolines()
{
}
