/***************************************************************************
                          logwidget.cpp  -  description
                             -------------------
    begin                : Mon Apr 30 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpaintdevicemetrics.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include "logwidget.h"

const int BORDER=3;

LogWidget::LogWidget(QWidget *parent, const char *name ) : QMultiLineEdit(parent,name) {
}
LogWidget::~LogWidget(){
}
void LogWidget::mouseReleaseEvent(QMouseEvent*){
  emit clicked();
}
int LogWidget::textWidthWithTabs(QString s, int nChars)
{
	if (!s) return 0;
	QFontMetrics fm=fontMetrics();
	if (nChars==-1)	nChars = strlen(s);
  int dist= -fm.minLeftBearing();
  QChar ch;
	int tabDist = tabLength();
  for (int z = 0; z < nChars; z++) {
    ch = s.at(z);
    dist += (ch == '\t') ? 	tabDist - (dist % tabDist) : fm.width(ch);
  }
	return dist;
}
void LogWidget::paintCell (QPainter *painter, int row, int col)
{
	QColorGroup colors=colorGroup();
	QString s(textLine(row));
	QRect r = cellUpdateRect();
	QRect *rect;
	QPixmap* buffer=new QPixmap(r.size());
	buffer->fill(colors.base());
	QPainter p;
	p.begin( buffer );
	p.translate( -r.left(), -r.top() );
	p.setTabStops(tabLength());
	p.setFont( painter->font() );

	//coloration syntaxique
	QList <QRect> fragments;
	fragments.clear();
	fragments.setAutoDelete(TRUE);
	QList <QColor> hicolors;
	hicolors.clear();
	hicolors.setAutoDelete(TRUE);
	
	for (int i=0; i < 3;i++)
	{
		int tagStart, tagEnd, startLength, endLength, parsedLength;
		tagStart = tagEnd = startLength = endLength = parsedLength = 0;
		while (parsedLength < cellWidth(col))
		{
			tagStart=s.find(sytax[i].w, tagEnd);
			
			if (tagStart == -1)	break;
      if ((sytax[i].w == "!") && (tagStart != 0)) break;
			else
			{
				tagEnd = tagStart + strlen(sytax[i].w);
				startLength = textWidthWithTabs(s,0);
				endLength = r.right();
  			rect = new QRect(BORDER + startLength - r.left(), -r.top(), endLength - startLength + 1, cellHeight(row));
				if (rect->isValid())
				{
					fragments.append(rect);
					QColor *cl = new QColor(sytax[i].c);
					hicolors.append(cl);
				}
				
				parsedLength=endLength;
			}
		}
	}

	//Texte
	p.setPen(colors.text());
	p.drawText(BORDER, 0, cellWidth(col)-BORDER, cellHeight(row), ExpandTabs, s);
	p.setClipping(TRUE);
	
	for (unsigned int i=0; i<fragments.count(); i++)
	{
		p.setClipRect(*fragments.at(i));
		p.setPen(*hicolors.at(i));
		p.drawText(BORDER, 0, cellWidth(col)-BORDER, cellHeight(row), ExpandTabs, s);
	}
	p.setClipping(FALSE);
	p.end();
	painter->drawPixmap(r.left(), r.top(), *buffer);
	delete(buffer);
}

void LogWidget::setupPainter(QPainter *painter)
{
		painter->setBackgroundColor(colorGroup().base());
}
