/***************************************************************************
                          tabdialog.cpp  -  description
                             -------------------
    begin                : Mon Apr 30 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabdialog.h"
#include <klocale.h>

tabdialog::tabdialog(QWidget *parent, const char *name)
    :KDialogBase( parent, 0L, true, name, Ok | Cancel, Ok )
{
	setCaption(name);
  QWidget *page = new QWidget(this);
  setMainWidget(page);

  QGridLayout *gbox = new QGridLayout( page, 3, 2, spacingHint() );
  gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );

  Table1 = new QTable( page, "Table1" );
  Table1->setNumRows( 2 );
  Table1->setNumCols( 2 );

  spinBoxRows= new QSpinBox(page,"NoName");
  spinBoxRows->setValue(2);
  spinBoxRows->setRange(1,99);
  connect( spinBoxRows, SIGNAL(valueChanged(int)),this, SLOT(NewRows(int)));

  spinBoxCollums= new QSpinBox(page,"NoName");
  spinBoxCollums->setValue(2);
  spinBoxCollums->setRange(1,99);
  connect( spinBoxCollums, SIGNAL(valueChanged(int)),this, SLOT(NewCollums(int)));

  QLabel_1= new QLabel(page,"NoName");
  QLabel_1->setText(i18n("Num of Rows"));

  QLabel_2= new QLabel(page,"NoName");
  QLabel_2->setText(i18n("Num of Columns"));

  QLabel_3= new QLabel(page,"NoName");
  QLabel_3->setText(i18n("Columns alignment"));

  combo = new QComboBox( FALSE, page, "comboBox" );
  combo->insertItem( "Center" );
  combo->insertItem( "Left" );
  combo->insertItem( "Right" );

  gbox->addMultiCellWidget(Table1,0,0,0,1,0);
  gbox->addWidget(QLabel_1 , 1, 0 );
  gbox->addWidget(spinBoxRows , 1, 1 );
  gbox->addWidget(QLabel_2 , 2, 0 );
  gbox->addWidget(spinBoxCollums , 2, 1 );
  gbox->addWidget(QLabel_3 , 3, 0 );
  gbox->addWidget(combo , 3, 1 );
  resize(460,300);
}

tabdialog::~tabdialog(){
}
void tabdialog::NewRows(int num)
{
  Table1->setNumRows( num );
}
void tabdialog::NewCollums(int num)
{
  Table1->setNumCols( num );
}
