.Dd April 25, 2002
.Dt KUVERT 1
.Os Unix
.Sh NAME
kuvert \- automatically sign and/or encrypt mail based on the recipients
.Sh SYNOPSIS
.Nm kuvert
.Op Fl d
.Op Fl r | Fl k | Fl n | Fl v
.Sh DESCRIPTION
.Nm kuvert 
reads mails from its queue, analyzes the recipients, decides to whom
it should encrypt and/or sign the mail using the PGP-MIME framework
defined in RFC2015 and sends the mail using your real MTA. kuvert can use
both old-style 2.x 
.Xr pgp 1
and modern 
.Xr gpg 1
at the same time, or can
coerce gpg into producing pgp-2.x-compatible signatures/encrypted data.
.Pp
The mail submission into the queue is usually done by
.Xr kuvert_mta_wrapper "1".
.Pp
The option 
.Fl r
causes an already running 
.Nm kuvert
process to reload the configuration file.
This is done by sending a SIGUSR1 to the running process.
.Pp
The option
.Fl d
activates debugging output to syslog.
.Nm kuvert 
does not fork when in debugging mode and processes just the
first mail in the queue, after which it terminates.
.Pp
The option
.Fl k
makes 
.Nm kuvert
kill an already running process.
.Pp
With the option
.Fl n
.Nm kuvert
does not 
.Xr fork 2
but keeps running in the foreground.
.Pp
The option
.Fl v
makes
.Nm kuvert
output its version number and exit immediately.
.Pp
At startup 
.Nm kuvert
reads the keyring(s) and the config file (if available),
then usually forks and runs the queue once every 60 seconds.
Whenever there is a file with a name consisting of digits only in the
queue, 
.Nm kuvert
will parse the mime structure into a temporary directory using 
.Xr MIME::Parser "3pm".
.Pp
.Nm kuvert
then decides whether the mail shall be left as is, clear-text signed
or signed and encrypted according to RFC2015.
This decision is done independently for every recipient of the
mail and works as follows: 
.Bl -bullet
.It
If a public key of the recipient is known, sign and encrypt.
.It 
If no public key of the recipient is known, just sign.
.El
.Pp
There are some options governing or overriding this basic setup, see
the section
.Sx CONFIGURATION
for details.
.Pp
Please note that 
.Nm kuvert uses the 
.Ql From:
and
.Ql Cc:
 headers to determine
the recipients. Additionally, if there is a 
.Ql Resend-To:
header, 
.Nm kuvert
will do no signing/encryption and send the mail just as it
is to the recipients indicated in the 
.Ql Resend-To:
header.
.Pp
Afterwards the parsed MIME entity is amended with the signature or
replaced with the encrypted data and is sent off using the MTA.
The temporary directory is cleaned and 
.Nm kuvert
processes either the
next queued message or waits for new messages.
.Pp
If there are problems, kuvert disables further processing of the respective
queuefile (it adds a 
.Ql \&. 
at the beginning of the filename, thus making the file ignored for further
queue-runs)
and sends an error message back to the sender.
.Sh CONFIGURATION
.Nm kuvert
allows for configuration with a configuration file
.Pa ~/.kuvert .
This file is read at startup or whenever you have 
.Nm kuvert 
reread the files using 
.Fl "r".
Empty lines and lines starting with
.Ql #
are ignored, as well as lines containing directives 
.Nm kuvert
can not interpret. 
.Pp
Directives can either be:
.Bl -bullet
.It
a directive name followed by whitespace and then a value,
.It 
or a regular expression matching an email address, followed by whitespace and an action keyword.
.El
.Pp
The list of directives kuvert understands:
.Bl -tag
.It Ar PGPPATH Pa path
defines the old-style compatible pgp executable to be used.
Default: 
.Pa /usr/bin/pgp
.It Ar GPGPATH Pa path
defines the gnupg-compatible new-style pgp executable to be used.
Default: 
.Pa /usr/bin/gpg
.It Ar USEPGP number
if number is not 0, kuvert will use the old-style pgp executable to generate 
old-style encryption/signatures. If it is 0, 
.Nm kuvert
will use gpg in a 
compatibility mode to produce the old-style stuff. Please note: gpg needs
the gnupg-extension gpg-idea for this compatibility mode.
Default: 0
.It Ar AGENTPATH Pa path
defines the quintuple-agent binary (see 
.Xr q-agent "1") to be used, if available. Default: none
.It Ar CLIENTPATH Pa path
defines the quintuple-client binary (see 
.Xr q-client "1") to be used, if available. Default: none
.It Ar SECRETONDEMAND number
if 1 and if agent and client are available, 
.Nm kuvert
will ask for the
key passphrases on demand, just when signing. If one of these requirements
is not given, 
.Nm kuvert
will ask for the passphrases at startup and will store
them itself. Default: 0
.It Ar ALWAYSTRUST number
if 1, add the alwaystrust parameter to gpg's invocation. see 
.Xr gpg "1" for details about this parameter. Default: 0
.It Ar LOGFILE Pa path
sets the file 
.Nm kuvert
logs its actions to. The logs are appended to that
file. Default: 
.Nm kuvert
usually logs to syslog.
.It Ar QUEUEDIR Pa path
sets the directory where kuvert_mta_wrapper and 
.Nm kuvert
put the queue of
mails to be processed. Default: 
.Pa ~/.kuvert_queue
.It Ar TEMPDIR Pa path
sets the directory 
.Nm kuvert
uses for temporary storage of the parts of the
parsed MIME entity. 
.Em Attention: This directory is cleaned after every mail handled and every file in there is removed!
Default: 
.Pa /tmp/kuvert.<uid>.<pid>.
.It Ar INTERVAL number
sets the queue check interval. the unit of measurement is seconds.
Default: 60 seconds
.It Ar NGKEY keyid
sets the owner's key id for new-style pgp/gpg. To disable new-style pgp/gpg
completely, set the keyid to "0". Default: the first private DSA key found is used.
.It Ar STDKEY keyid
sets the owner's key id for old-style pgp. To disable old-style pgp completely, set the keyid to 0. Default: the first private RSA key found is used.
.It Ar DEFAULT action
specifies the action to be taken for unspecified recipient addresses.
See the next paragraphs for an explanation of the 
.Ar action
argument.
.El
.Pp
All lines not starting with the pound sign 
.Ql #
or a recognized directive
are interpreted as a 
.Xr perl 1 
regular expression followed by whitespace and an
action keyword. 
.Pp
The regular expressions are applied to the email address
of the recipients of the mail, and the action keyword describes how to
modify 
.Nm kuvert Ns
\&'s behavious for a recipient.
.Pp
The regular expression has to be written without the bracketing 
.Ql / Ns
-characters.
The regular expressions are evaluated case-insensitively,
and in the order given in the configuration file. The first matching regexp
ends the evaluation sequence.
.Pp
The default action is to do not encrypt or sign at all, so you should
set a default that is reasonable for you by using the 
.Ql DEFAULT
directive.
.Pp
The known action keywords are:
.Bl -tag
.It Ar none
Send it as it is, do not sign or encrypt at all. The MIME structure of 
the mail is not changed in whatever way before sending. 
This is the default action. 
.Pp
This option is 
.Em slightly special:
An explicitly set action of 
.Ql none
is 
.Em not affected or overridden 
by any of the 
.Ar -force
options or by the override header.
.It Ar std
Use just old-style pgp. If there is an old-style key known, encrypt and sign
using this old-style key and the owner's old-style key, otherwise just sign
using the owner's old-style key.
.It Ar ng
Use just new-style pgp, similar to the above.
.It Ar stdsign
Never encrypt, just sign using the owner's old-style key.
.It Ar ngsign
Never encrypt, just sign using the owner's new-style key.
.It Ar fallback
Encrypt with new-style, old-style or just sign with new-style.
If there is a new-style key of the recipient known, encrypt and sign with
this key, else if there is an old-style key, encrypt and sign with this
key. Otherwise just sign with the owner's new-style key.
.It Ar none-force
Force no encryption/signing for all recipients of this mail.
.It Ar fallback-force
Force a fallback-type action for the recipients of this mail:
 encrypt and sign with new-style or old-style pgp if keys for 
.Em all affected
recipients are available or sign with new-style pgp. Recipients with 
an action set to 
.Ql none
are 
.Em not affected 
by fallback-force. Also note that a mixture of
old-style and new-style encryption is possible with fallback-force.
.It Ar ngsign-force "," stdsign-force
Sign only for all affected recipients, with new-style or old style pgp respectively. Again recipients with action 
.Ql none
are 
.Em not affected.
.It Ar ng-force
Encrypt and sign for all recipients of this mail if there is a new-style key
available for all of them, otherwise just sign for all of them using
new-style pgp. The difference between this action
and 
.Ar fallback-force
is that there's no mixing of old-style and new-style pgp possible here.
Again recipients with action 
.Ql none
are 
.Em not affected.
.It Ar std-force
like 
.Ar ng-force ","
but with old-style pgp.
Again recipients with action 
.Ql none
are 
.Em not affected.
.El
.Pp
Additionally, you can specify an override for a single mail by
adding a header to the mail of the form
.Ql X-Kuvert: Ar action
where action is one of the action keywords just listed
above. This override will be applied to all recipients of the given
mail and will override all action specifications given in the configuration
file, except the explicit 
.Ql none Ns
s. Before final sending an email
.Nm kuvert
will remove
any existing override header from the email.
.Pp
The various
.Ar -force 
actions are intended for users who want to avoid sending cleartext (signed)
and encrypted variants of the same mail to different recipients: You can 
either turn off encryption or signing completely, or use the maximum
amount of privacy that is possible for a given set of recipients by checking
for keys for everybody before deciding whether to encrypt or just sign.
.Pp
The special handling for 
.Ql none
oes break this paradigma a bit, but is
necessary to make the 
.Ar -force
a safe choice for your 
.Ql DEFAULT
action: Otherwise 
.Nm kuvert
would send stuff signed or encrypted to recipients you know to be 
completely unable/unwilling to accept signed or encrypted mail
(like mail robots). Therefore these were made unaffected (and disregarded)
by the 
.Ar -force
options.
.Pp
.Sy Please note: the first occurrence of a -force action overrides all possible other occurrences!
.Sh FILES
.Bl -tag
.It Pa ~/.kuvert
configuration file for 
.Nm kuvert
and 
.Xr kuvert_mta_wrapper "1".
.It Pa ~/.kuvert_queue
the default queue directory for 
.Nm kuvert
if the configuration file does not specify an alternative.
.It Pa /tmp/kuvert.pid.<uid>
holds the pid of a running process.
.El
.Sh SEE ALSO
.Xr kuvert_mta_wrapper "1",
.Xr q-agent "1",
.Xr q-agent "1",
.BR gpg "1",
.BR pgp "1",
RFC2015, RFC2440
.Sh AUTHORS
.An Alexander Zangerl <az@snafu.priv.at>
.Sh BUGS
The MTA to be used is set in the program itself.
Currently 
.Nm kuvert
needs something sendmail-like in 
.Pa /usr/lib/sendmail
that understands 
.Fl t,
.Fl om,
.Fl oi
and
.Fl "oem".
.Pp
.Ql Bcc:
is not interpreted by kuvert at the moment.
.Pp
Multiple -force actions won't work.
