// =============================================================================
//
//      --- kvi_dirview_item.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDirViewItem"

#include "kvi_app.h"
#include "kvi_defines.h"
#include "kvi_dirview.h"
#include "kvi_dirview_item.h"
#include "kvi_frame.h"
#include "kvi_iconloader.h"

static const QString g_iUnreadableDir("folder_locked.png");
static const QString g_iUnreadableFile("file_locked.png");
static const QString g_iDirectory("folder.png");
static const QString g_iSymlink("symlink.png");
static const QString g_iSocket("socket.png");
static const QString g_iDevice("device.png");
static const QString g_iUnknown("unknown.png");

KviDirectoryViewItem::KviDirectoryViewItem(KviDirectoryView *view, KviDirBrowserEntry *e)
	: KviIconViewItem(view)
{
	m_view = view;
	m_data = e;
	setText(m_data->szFileName.ptr());
	setDragEnabled(true);
	setDropEnabled(false);

	if( !(m_data->bIsReadable) ) {
		if( m_data->bIsDirectory )
			setPixmap(KviIconLoader::loadMimeIcon(g_iUnreadableDir));
		else
			setPixmap(KviIconLoader::loadMimeIcon(g_iUnreadableFile));
		return;
	}

	if( m_data->szIconPath.hasData() )
	{
		QPixmap *pix = g_pApp->getFileIcon(m_data->szIconPath.ptr());
		if( pix ) {
			setPixmap(*pix);
			return;
		}
	}

	if( m_data->bIsDirectory ) {
		setPixmap(KviIconLoader::loadMimeIcon(g_iDirectory));
		setDropEnabled(true);
	} else if( m_data->bIsSymLink ) {
		setPixmap(KviIconLoader::loadMimeIcon(g_iSymlink));
	} else if( m_data->bIsSocket ) {
		setPixmap(KviIconLoader::loadMimeIcon(g_iSocket));
	} else if( m_data->bIsDevice ) {
		setPixmap(KviIconLoader::loadMimeIcon(g_iDevice));
	} else setPixmap(KviIconLoader::loadMimeIcon(g_iUnknown));
}

KviDirectoryViewItem::~KviDirectoryViewItem()
{
	delete m_data;
	m_data = 0;
}
