// =============================================================================
//
//      --- kvi_options_view.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsView"

#define _KVI_OPTIONS_VIEW_CPP_

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_combobox.h"
#include "kvi_defines.h"
#include "kvi_integerselector.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_view.h"
#include "kvi_string.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsView
	@widget: View widget options
		Here you can set the view widget options.<br>
		The "View widget buffer size" is the number of lines that the widget
		will keep in memory as "scrollback" buffer.<br>
		The widget is able to highlight PRIVATE MESSAGES that contain
		specified words.<br>
		This feature is commonly used to highlight lines that contain your own nickname.<br>
		Multiple words can be specified, separating it by spaces.<br>
		The widget is also able to recognize common URL formats and to
		show it as clickable links.<br>
		The action taken after the double-click may be specified as "Browser commandline": it is a shell command.<br>
		KVIrc comes with a shell script called kvi_run_netscape.sh that is able to
		redirect the url to an existing Netscape window or to start a new session
		if no window is currently open.<br>
		You may also decide to use a different browser: just put the command to be executed
		in the "Browser commandline" option input line.<br>
		The '%' character in that commandline will be substituted with the double-clicked URL.<br>
		Examples:<br><br>
		<b>kvi_run_netscape.sh %</b><br>
		<b>netscape %</b><br>
		<b>kfmclient openURL %</b><br>
		<b>kfmexec openURL %</b><br>
		<b>opera -remote openURL(%, new-window)</b><br><br>
*/
KviOptionsView::KviOptionsView(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW)
{
	QGridLayout *g = new QGridLayout(
		this, 21, 2, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviIntegerSelector *i = new KviIntegerSelector(this,
		_i18n_("View widget buffer size (32-65535):"),
		&(g_pOptions->m_iViewMaxBufferSize), KviIntegerSelector::Int, 32, 65535, KVI_IRC_VIEW_MAX_LINES, true, 180
	);
	g->addMultiCellWidget(i, 0, 0, 0, 1);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 1, 1, 0, 1);

	KviBoolSelector *b = new KviBoolSelector(this,
		_i18n_("When selecting text, copy to clipboard instead of displaying menu"),
		&(g_pOptions->m_bDoNotShowThePopupOnTextSelected)
	);
	g->addMultiCellWidget(b, 2, 2, 0, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 3, 3, 0, 1);

	b = new KviBoolSelector(this,
		_i18n_("Highlight text that contains specified words (for privmsg && notice only)"),
		&(g_pOptions->m_bWordHighlighting)
	);
	g->addMultiCellWidget(b, 4, 4, 0, 1);
	KviStringSelector *s = new KviStringSelector(this,
		_i18n_("Words to highlight (separate with spaces):"),
		&(g_pOptions->m_szHighlightWords), g_pOptions->m_bWordHighlighting, 180
	);
	g->addMultiCellWidget(s, 5, 5, 0, 1);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 6, 6, 0, 1);

	b = new KviBoolSelector(this, _i18n_("Highlight URLs"), &(g_pOptions->m_bUrlHighlighting));
	g->addMultiCellWidget(b, 7, 7, 0, 1);

	KviLabel *l = new KviLabel(_CHAR_2_QSTRING(_i18n_("Open URLs with:")), this);
	g->addWidget(l, 8, 0);
	connect(b, SIGNAL(toggled(bool)), l, SLOT(setEnabled(bool)));

	m_pBrowserCommandlineBox = new KviComboBox(false, this);
	g->addWidget(m_pBrowserCommandlineBox, 8, 1);
	connect(b, SIGNAL(toggled(bool)), m_pBrowserCommandlineBox, SLOT(setEnabled(bool)));

	l = new KviLabel(_CHAR_2_QSTRING(_i18n_("Browser commandline (% = URL):")), this);
	g->addWidget(l, 9, 0);
	connect(b, SIGNAL(toggled(bool)), l, SLOT(setEnabled(bool)));

	m_pBrowserCommandlineEdit = new KviLineEdit(this);
	m_pBrowserCommandlineEdit->setText(g_pOptions->m_szBrowserCommandline.ptr());
	g->addWidget(m_pBrowserCommandlineEdit, 9, 1);
	connect(b, SIGNAL(toggled(bool)), m_pBrowserCommandlineEdit, SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 10, 10, 0, 1);

	b = new KviBoolSelector(this, _i18n_("Privmsg nicknames are links"), &(g_pOptions->m_bPrivmsgFormatNickIsALink));
	g->addMultiCellWidget(b, 11, 11, 0, 1);
	s = new KviStringSelector(this,
		_i18n_("Double-click on nickname link executes command:"),
		&(g_pOptions->m_szPrivmsgFormatNickLinkCommand), g_pOptions->m_bPrivmsgFormatNickIsALink, 180
	);
	connect(b, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s, 12, 12, 0, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 13, 13, 0, 1);

	KviLabel *l1 = new KviLabel(
		_CHAR_2_QSTRING(_i18n_("This is the extended privmsg nickname format: [prefix]nick[!user@host][postfix]")),
		this
	);
	g->addMultiCellWidget(l1, 14, 14, 0, 1);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		_i18n_("Use extended privmsg nick formatting"), &(g_pOptions->m_bUseExtendedPrivmsgView)
	);
	g->addMultiCellWidget(b1, 15, 15, 0, 1);
	b = new KviBoolSelector(this,
		_i18n_("Show user and host in privmsgs"),
		&(g_pOptions->m_bShowUserAndHostInPrivmsgs), g_pOptions->m_bUseExtendedPrivmsgView
	);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(b, 16, 16, 0, 1);
	s = new KviStringSelector(this,
		_i18n_("Nickname format prefix:"),
		&(g_pOptions->m_szExtPrivmsgPrefix), g_pOptions->m_bUseExtendedPrivmsgView, 180
	);
	connect(b1, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s, 17, 17, 0, 1);
	s = new KviStringSelector(this,
		_i18n_("Nickname format postfix:"),
		&(g_pOptions->m_szExtPrivmsgPostfix), g_pOptions->m_bUseExtendedPrivmsgView, 180
	);
	connect(b1, SIGNAL(toggled(bool)), s, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s, 18, 18, 0, 1);
	b = new KviBoolSelector(this, _i18n_("Prefix nicknames with channel mode"), &(g_pOptions->m_bEnableNickModePrefix));
	g->addMultiCellWidget(b, 19, 19, 0, 1);

	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f, 20, 20, 0, 1); // f, 19, 0
	g->setRowStretch(20, 1); // 19, 1

	fillBrowserCommandlineBox();
}

KviOptionsView::~KviOptionsView()
{
	// Nothing here
}

static const char *browserCommandlineTable[] = {
	"kfmclient exec %",
	"mozilla -remote openurl(%,new-tab)",
	"kvi_run_netscape.sh %",
	"opera -remote openurl(%,new-window)",
	"galeon %",
	"skipstone %",
	"xterm -ls -e links %",
	"xterm -ls -e lynx %",
	0
};

void KviOptionsView::fillBrowserCommandlineBox()
{
	int index = 8;
	m_pBrowserCommandlineBox->insertItem("Konqueror");
	m_pBrowserCommandlineBox->insertItem("Mozilla");
	m_pBrowserCommandlineBox->insertItem("Netscape");
	m_pBrowserCommandlineBox->insertItem("Opera");
	m_pBrowserCommandlineBox->insertItem("Galeon");
	m_pBrowserCommandlineBox->insertItem("SkipStone");
	m_pBrowserCommandlineBox->insertItem("Links");
	m_pBrowserCommandlineBox->insertItem("Lynx");
	m_pBrowserCommandlineBox->insertItem(_i18n_("Other browser"));
	if( g_pOptions->m_szBrowserCommandline.isEmpty() )
		index = 0;
	else for( int i = 0; i < 8; i++ ) {
		if( kvi_strEqualCS(g_pOptions->m_szBrowserCommandline.ptr(), browserCommandlineTable[i]) ) {
			index = i;
			break;
		}
	}
	m_pBrowserCommandlineBox->setCurrentItem(index);
	connect(m_pBrowserCommandlineBox, SIGNAL(activated(int)), this, SLOT(fillBrowserCommandlineEdit(int)));
}

void KviOptionsView::fillBrowserCommandlineEdit(int index)
{
	if( m_pBrowserCommandlineBox->currentItem() < 8 )
		m_pBrowserCommandlineEdit->setText(browserCommandlineTable[m_pBrowserCommandlineBox->currentItem()]);
	else if( !g_pOptions->m_szBrowserCommandline.isEmpty() )
		m_pBrowserCommandlineEdit->setText(g_pOptions->m_szBrowserCommandline.ptr());
}

void KviOptionsView::commitChanges()
{
	KviIntegerSelector::commitAll(this);
	KviBoolSelector::commitAll(this);
	KviStringSelector::commitAll(this);
	g_pOptions->fillHighlightWordsList();
	g_pOptions->m_szBrowserCommandline = m_pBrowserCommandlineEdit->text();
}

#include "m_kvi_options_view.moc"
