// =============================================================================
//
//      --- kvi_toolbarlistview.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviToolBarListView"

#include <qpixmap.h>

#include "kvi_app.h"
#include "kvi_defines.h"
#include "kvi_toolbarlistview.h"

extern QPixmap *g_pixViewOut[KVI_OUT_NUM_IMAGES];

KviToolBarListViewItem::KviToolBarListViewItem(
	ToolButtonType t, KviListView *parent,
	const char *name, const char *type, const char *buffer, const char *icon, const char *sbar)
	: KviListViewItem(parent, _CHAR_2_QSTRING(name), _CHAR_2_QSTRING(type))
{
	if( buffer ) m_buffer = buffer;
	if( icon   ) m_icon   = icon;
	m_sbar = sbar;
	m_id   = 0;
	m_type = t;
	tryLoadImage();
}

/**
 * ==================== Constructor: Add below =================
 */
KviToolBarListViewItem::KviToolBarListViewItem(
	ToolButtonType t, KviListView *parent, KviToolBarListViewItem *after,
	const char *name, const char *type, const char *buffer, const char *icon, const char *sbar)
	: KviListViewItem(parent, after, _CHAR_2_QSTRING(name), _CHAR_2_QSTRING(type))
{
	if( buffer ) m_buffer = buffer;
	if( icon   ) m_icon   = icon;
	m_sbar = sbar;
	m_type = t;
	m_id   = 0;
	tryLoadImage();
}

/**
 * ==================== Constructor: Add menu =================
 */
KviToolBarListViewItem::KviToolBarListViewItem(
	ToolButtonType t, KviToolBarListViewItem *parent,
	const char *name, const char *type, const char *buffer, const char *icon, const char *sbar)
	: KviListViewItem(parent, _CHAR_2_QSTRING(name), _CHAR_2_QSTRING(type))
{
	if( buffer ) m_buffer = buffer;
	if( icon   ) m_icon   = icon;
	m_sbar = sbar;
	m_type = t;
	m_id   = 0;
	tryLoadImage();
}

/**
 * ==================== Constructor: Add menu below ============
 */
KviToolBarListViewItem::KviToolBarListViewItem(
	ToolButtonType t, KviToolBarListViewItem *parent, KviToolBarListViewItem *after,
	const char *name, const char *type, const char *buffer, const char *icon, const char *sbar)
	: KviListViewItem(parent, after, _CHAR_2_QSTRING(name), _CHAR_2_QSTRING(type))
{
	if( buffer ) m_buffer = buffer;
	if( icon   ) m_icon   = icon;
	m_sbar = sbar;
	m_type = t;
	m_id   = 0;
	tryLoadImage();
}

/**
 * ==================== Destructor =================
 */
KviToolBarListViewItem::~KviToolBarListViewItem()
{
	// Nothing here
}

/**
 * ==================== tryLoadImage =================
 */
void KviToolBarListViewItem::tryLoadImage()
{
	m_icon.stripWhiteSpace();
	if( m_icon.hasData() ) {
		if( m_icon.isNum() ) {
			bool bOk = false;
			int imId = m_icon.toInt(&bOk);
			if( imId >= 0 ) {
				imId = imId % KVI_OUT_NUM_IMAGES;
				setPixmap(0, *(g_pixViewOut[imId]));
			}
		} else {
			KviStr imagePath;
			if( g_pApp->findImage(imagePath, m_icon.ptr()) ) {
				QPixmap pix(imagePath.ptr());
				if( !pix.isNull() ) {
					setPixmap(0, pix);
				} else debug("Unable to find image file %s", m_icon.ptr());
			}
		}
	}
}
