#ifndef _SETUPWIZARD_H_
#define _SETUPWIZARD_H_
//
//   File : setupwizard.h
//   Creation date : Sat Oct  6 02:06:51 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include <qwizard.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>

#include "kvi_settings.h"
#include "kvi_string.h"

class KviSetupWizard;

class KviSetupPage : public QHBox
{
	Q_OBJECT
public:
	KviSetupPage(KviSetupWizard * w);
	~KviSetupPage();
public:
	QVBox * m_pVBox;
	QLabel * m_pPixmapLabel;
	QLabel * m_pTextLabel;
   
};


#define THEME_APPLY_NONE 0
#define THEME_APPLY_HIRES 1
#define THEME_APPLY_LORES 2

class KviSetupWizard : public QWizard
{
	Q_OBJECT
public:
	KviSetupWizard();
	~KviSetupWizard();
public:
	QPixmap       * m_pLabelPixmap;
	QLineEdit     * m_pDataPathEdit;
	QLineEdit     * m_pIncomingPathEdit;
	QLineEdit     * m_pNickEdit;
	KviSetupPage  * m_pWelcome;
	KviSetupPage  * m_pLicense;
	KviSetupPage  * m_pIdentity;
	KviSetupPage  * m_pDirectory;
	KviSetupPage  * m_pTheme;
	KviSetupPage  * m_pLink;
	KviSetupPage  * m_pUrlHandlers;
	KviSetupPage  * m_pFinish;
	QVButtonGroup * m_pUrlHandlersButtonGroup;
	QRadioButton  * m_pUrlHandlersYes;
	QRadioButton  * m_pUrlHandlersNo;
	QVButtonGroup * m_pLinkButtonGroup;
	QRadioButton  * m_pLinkYes;
	QRadioButton  * m_pLinkNo;
	QVButtonGroup * m_pThemeButtonGroup;
	QRadioButton  * m_pThemeHiRes;
	QRadioButton  * m_pThemeLoRes;
	QRadioButton  * m_pThemeNone;
      
protected:
	void makeLink();
	void setUrlHandlers();
public slots:
	void chooseDataPath();
	void chooseIncomingPath();
	virtual void accept();
	virtual void reject();
};


#endif //_SETUPWIZARD_H_
