// =============================================================================
//
//      --- kvi_integerselector_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviIntegerSelector"

#include <qlabel.h>
#include <qobjectlist.h>

#include "kvi_debug.h"
#include "kvi_integerselector_kde.h"

KviIntegerSelector::KviIntegerSelector(
	QWidget *parent, const char *description, void *pNumber, IntSelectorType type,
	int lowerBound, int upperBound, int defValue, bool bEnabled, int fieldWidth,
	const char *name, const char *suffix)
	: KIntNumInput(defValue, parent, 10, name)
{
	__range_valid(pNumber);
	m_pNumber     = pNumber;
	m_type        = type;
	m_iFieldWidth = (fieldWidth > 0) ? fieldWidth : 100;
	setMinValue(lowerBound);
	setMaxValue(upperBound);
	setLabel(_CHAR_2_QSTRING(description), AlignLeft | AlignVCenter);
	if( *suffix ) setSuffix(suffix);

	switch( type ) {
		case UInt :
			setValue(*((unsigned int *) (pNumber)));
			break;
		case UShort:
			setValue(*((unsigned short int *) (pNumber)));
			break;
		case Short:
			setValue(*((short int *) (pNumber)));
			break;
		default:
			setValue(*((int *) (pNumber)));
			break;
	}
	setEnabled(bEnabled);
}

KviIntegerSelector::~KviIntegerSelector()
{
	// Nothing here
}

void KviIntegerSelector::commitChanges()
{
	switch( m_type ) {
		case UInt:
			(*((unsigned int *) m_pNumber)) = (unsigned int) value();
			break;
		case UShort:
			(*((unsigned short *) m_pNumber)) = (unsigned short) value();
			break;
		case Short:
			(*((short *) m_pNumber)) = (short) value();
			break;
		default:
			(*((int *) m_pNumber)) = value();
			break;
	}
}

void KviIntegerSelector::commitAll(QWidget *w)
{
	QObjectList *l = w->queryList("KviIntegerSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviIntegerSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviIntegerSelector::resizeEvent(QResizeEvent *ev)
{
	KIntNumInput::resizeEvent(ev);
	m_spin->setGeometry(width() - m_iFieldWidth, 0, m_iFieldWidth, height());
	m_label->setGeometry(0, 0, width() - (m_iFieldWidth + 1), height());
}

#include "m_kvi_integerselector_kde.moc"
