#ifndef _KVI_LISTVIEW_QT_H_INCLUDED_
#define _KVI_LISTVIEW_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_listview_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qlistview.h>

class QBitArray;

class KviFieldEditor;
class KviListViewItem;

class KviListView : public QListView
{
	Q_OBJECT
public:
	KviListView(QWidget *parent = 0, const char *name = 0, bool editable = false);
	~KviListView();
protected:
	int              m_iColumnCount;
	int              m_iCurEditedColumn;
	bool             m_resizeToContents;
	KviFieldEditor  *m_pEditor;
	KviListViewItem *m_pCurEditedItem;
	QBitArray       *m_numeric;
public:
	void setFieldEditor(KviFieldEditor *);
	QSize sizeHint() const;
	void setAutoResize(const bool);

	virtual int  addColumn(const QString &label, bool isNumeric = false, int width = -1);
	virtual void removeColumn(int);
	void editField(KviListViewItem *it, int column, bool bEnd = true);
	bool eventFilter(QObject *, QEvent *);

	KviListViewItem *firstChild();
	KviListViewItem *itemAt(const QPoint &viewPos) const;
	KviListViewItem *selectedItem();

	bool isNumeric(int col) const;
protected slots:
	void itemDoubleClicked(KviListViewItem *it);
	void editTerminated(const QString &text);
	void editorKeyUp();
	void editorKeyDown();
	void editorKeyRight();
	void editorKeyLeft();
public slots:
	void slot_currentChanged(QListViewItem *);
	void slot_doubleClicked(QListViewItem *);
	void slot_selectionChanged(QListViewItem *);
	void slot_rightButtonPressed(QListViewItem *, const QPoint &, int);
signals:
	void doubleClicked(KviListViewItem *);
	void currentChanged(KviListViewItem *);
	void selectionChanged(KviListViewItem *);
	void rightButtonPressed(KviListViewItem *, const QPoint &, int);
};

class KviListViewItem : public QListViewItem
{
public:
	KviListViewItem(KviListView *parent);
	KviListViewItem(
		KviListView *parent, QString label1, QString label2 = QString::null,
		QString label3 = QString::null, QString label4 = QString::null,
		QString label5 = QString::null, QString label6 = QString::null,
		QString label7 = QString::null, QString label8 = QString::null
	);
 	KviListViewItem(
		KviListView *parent, KviListViewItem *after, QString label1, QString label2 = QString::null,
		QString label3 = QString::null, QString label4 = QString::null,
		QString label5 = QString::null, QString label6 = QString::null,
		QString label7 = QString::null, QString label8 = QString::null
	);
	KviListViewItem(
		KviListViewItem *parent, QString label1, QString label2 = QString::null,
		QString label3 = QString::null, QString label4 = QString::null,
		QString label5 = QString::null, QString label6 = QString::null,
		QString label7 = QString::null, QString label8 = QString::null
	);
	KviListViewItem(
		KviListViewItem *parent, KviListViewItem *after, QString label1, QString label2 = QString::null,
		QString label3 = QString::null, QString label4 = QString::null,
		QString label5 = QString::null, QString label6 = QString::null,
		QString label7 = QString::null, QString label8 = QString::null
	);

	~KviListViewItem();

	KviListViewItem *firstChild();
	KviListViewItem *itemAbove();
	KviListViewItem *itemBelow();
	KviListViewItem *nextSibling();
	KviListViewItem *parent();

	int compare(QListViewItem *, int col, bool) const;
};

class KviListViewItemIterator : public QListViewItemIterator
{
public:
	KviListViewItemIterator(KviListView *);

	KviListViewItem *current();
};

#endif // _KVI_LISTVIEW_QT_H_INCLUDED_
