#ifndef _KVI_DIRBROWSER_WIDGET_H_INCLUDED_
#define _KVI_DIRBROWSER_WIDGET_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dirbrowser_widget.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

#include "kvi_dirbrowser_thread.h"
#include "kvi_string.h"

class QIconViewItem;

class KviDirectoryView;
class KviFrame;
class KviLineEdit;
class KviPopupMenu;
class KviToolBar;

class KviDirectoryBrowserWidget : public QWidget
{
	Q_OBJECT
public:
	KviDirectoryBrowserWidget(QWidget *parent, KviFrame *lpFrm, const char *dirname);
	~KviDirectoryBrowserWidget();
public:
	int                 m_bookmarkButton;
	int                 m_closeButton;
	int                 m_homeButton;
	int                 m_kvircHomeButton;
	int                 m_reloadButton;
	int                 m_upButton;
	KviFrame           *m_pFrm;
	KviDirectoryView   *m_pDirView;
	KviToolBar         *m_pToolBar;
	KviLineEdit        *m_pDirPathEdit;
	KviStr              m_szDirPath;
	KviDirBrowserJob   *m_pJob;
	KviDirectoryThread *m_pChildThread;
	KviPopupMenu       *m_pBookmarksPopup;
public:
	bool loadDirectory(const char *dirname);
	void stop();
	void applyOptions();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual bool event(QEvent *);
private:
	bool setDirPathAndEnsureReadable(const char *dirname);
	bool beginReadCurrentDirectory();
	bool isDirReadable(const char *dirname);
public slots:
	void cdUp();
	void cdReload();
	void cdHome();
	void cdKviHome();
	void showBookmarksPopup();
	void bookmarkSelected(int id);
protected slots:
	void itemExecuted(QIconViewItem *);
	void selectionChanged();
	void returnPressed();
};

#endif // _KVI_DIRBROWSER_WIDGET_H_INCLUDED_
