// =============================================================================
//
//      --- kvi_asyncfiledialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviAsyncFileDialog"

#include "kvi_app.h"
#include "kvi_asyncfiledialog.h"

KviAsyncFileDialog::KviAsyncFileDialog(KviUserParser *parser, KviWindow *pWnd)
	: KviFileDialog(QString::null, QString::null, 0, 0)
	, KviAsyncDialog(parser, pWnd)
{
	// Nothing here
}

KviAsyncFileDialog::~KviAsyncFileDialog()
{
	// Nothing here
}

void KviAsyncFileDialog::openFileName()  { setMode(ExistingOnly);  show(); }
void KviAsyncFileDialog::saveFileName()  { setMode(File);          show(); }
void KviAsyncFileDialog::openFileNames() { setMode(Files);         show(); }
void KviAsyncFileDialog::openDirectory() { setMode(Directory);     show(); }

void KviAsyncFileDialog::done(int r)
{
	KviFileDialog::done(r);
	KviStr tmp = selectedFile();
	runJob(((result() == Accepted) ? tmp.ptr() : ""));
	g_pApp->destroyLater(this);
}

#include "m_kvi_asyncfiledialog.moc"
