#ifndef _KVI_SYSTRAY_H_INCLUDED_
#define _KVI_SYSTRAY_H_INCLUDED_

// =============================================================================
//
//      --- kvi_systray.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>
#include <qwidget.h>

class QPixmap;

class KviSysTrayIconDisplay;
class KviSysTrayWidget;

class KviSysTray : public QWidget
{
	Q_OBJECT
public:
	KviSysTray(QWidget *parent);
	~KviSysTray();
public:
	QPtrList<KviSysTrayWidget> *m_pWidgetList;
protected:
	KviSysTrayIconDisplay *m_pIconDisplay;
	KviSysTrayWidget      *m_pCurrentWidget;
	QPixmap               *m_pMemBuffer;
public:
	KviSysTrayWidget *currentWidget();
	void rotateMode();
	KviSysTrayWidget *findSysTrayWidget(const char *classname);

	void  addPluginWidget(KviSysTrayWidget *w, bool bShow = true);
	bool setCurrentWidget(KviSysTrayWidget *w);
	void     removeWidget(KviSysTrayWidget *w, bool bDelete = true);

	void killPluginWidgets(void *plugin_handle);
	virtual QSize sizeHint();
protected:
	virtual void resizeEvent(QResizeEvent *);
public:
	inline QPixmap *getMemoryBuffer()        { return m_pMemBuffer; };
	QColor getBackground();
	QColor getForeground();
};

static const QString SYSTRAY_ICON_CLOCK("clock_dock.png");
static const QString SYSTRAY_ICON_UTC_CLOCK("utcclock_dock.png");
static const QString SYSTRAY_ICON_ONLINE_TIMER("timer_dock.png");
static const QString SYSTRAY_ICON_IO_LED("ioled_dock.png");

#endif // _KVI_SYSTRAY_H_INCLUDED_
