#ifndef _KVI_STYLE_BASIC_H_INCLUDED_
#define _KVI_STYLE_BASIC_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qplatinumstyle.h>

class KviPushButton;

class KviBasicStyle : public QPlatinumStyle
{
	Q_OBJECT
public:
	KviBasicStyle();
	~KviBasicStyle();
protected:
	virtual void   polish(QWidget *);
	virtual void unPolish(QWidget *);

	void drawBasicShape(
		QPainter *p, const QColorGroup &g, int x1, int y1, int x2, int y2,
		bool bSunken, bool bEnabled, bool bSpecial, bool bDoubleBorder = true
	);

	virtual void drawPushButton(KviPushButton *, QPainter *);
	virtual void drawPushButtonLabel(KviPushButton *, QPainter *);
	void drawPopupMenuItem(
		QPainter *p, bool checkable, int maxpmw, int tab, QMenuItem *mi,
		const QPalette &pal, bool act, bool enabled, int x, int y, int w, int h
	);
};

#endif // _KVI_STYLE_BASIC_H_INCLUDED_
