/*****************************************************************************
 * Copyright (C) 2005 by hal9000 <hal9000@evilscientists.de>                 *
 * Copyright (C) 2005 by Maurice Massar <vpnc@unix-ag.uni-kl.de>             *
 * Copyright (C) 2005-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef CISCOPASSWDDECODER_H
#define CISCOPASSWDDECODER_H

#pragma once

#include <QtCore/QString>

#include <cstdio>
#include <cstdlib>
#include <cerrno>
#include <fstream>
#include <string>
#include <gcrypt.h>

/*
 * To get some .pcf file specifications,
 * see Cisco VPN Client Administrator Guide
 * chapter Preconfiguring the VPN Client for Remote Users
 */
class CiscoPasswdDecoder
{
public:
    CiscoPasswdDecoder(QString& profileFile);
    ~CiscoPasswdDecoder();

    bool decodePasswords(QString& userPasswd, QString& groupPasswd);

private:
    void readProfileData(QString& profile, QString& userData, QString& groupData);
    QString profile;

    int hex2bin_c(unsigned int c);
    int hex2bin(QString str, QString& bin, int& len);
    int c_decrypt(QString ct, int len, char **resp, int reslenp);
};

#endif
