

#include "kprofilesdlg.h"
#include "kwlaninterface.h"

#include <qlistbox.h>
#include <qstringlist.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <qlistbox.h>
#include <klocale.h>

KProfilesDlg::KProfilesDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KProfiles(parent,name, modal,fl)
{
    m_interface=0L;
}

KProfilesDlg::~KProfilesDlg()
{
}


void KProfilesDlg::setInterface( KWlanInterface *interface)
{
    kdDebug() << "setting interface " << endl;
    m_interface = interface;
    connect (this, SIGNAL(sigNewProfile()), m_interface, SLOT(slotNewProfile()));
    connect (this, SIGNAL(sigScan()), m_interface, SLOT(slotScan()));
    connect (this, SIGNAL(sigEditProfile( QString)), m_interface, SLOT(slotEditProfile(QString)));
    connect (this, SIGNAL(sigDeleteProfile( QString)), m_interface, SLOT(slotDeleteProfile(QString)));
    connect (m_interface, SIGNAL(networksChanged()), this, SLOT(updateProfiles()));
    updateProfiles();
}

void KProfilesDlg::scan()
{
    emit (sigScan());
}

void KProfilesDlg::deleteProfile()
{
    // get Profile
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No Profile selected!"));
        return;
    }
    
    
    int answer = KMessageBox::warningYesNo(this,i18n("Do you really want to delete this profile?"));
    if (answer==KMessageBox::Yes){
        emit (sigDeleteProfile(lbProfiles->currentText()));
    }
}

void KProfilesDlg::editProfile()
{
    // get Profile
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No Profile selected!"));
        return;
    }
    
    emit sigEditProfile( lbProfiles->currentText());    
}

void KProfilesDlg::newProfile()
{
    emit (sigNewProfile());
}

void KProfilesDlg::updateProfiles()
{
    if (!m_interface) return;
    QStringList networks;
    //kdDebug() << "Updating profile list..." << endl;
    lbProfiles->clear();
    //m_tray->clearProfiles();
    networks= m_interface->listProfiles();
    for (QStringList::Iterator it=networks.begin();it != networks.end();it++){
        lbProfiles->insertItem(*it);
    }
}


#include "kprofilesdlg.moc"

