#ifndef KPROFILESDLG_H
#define KPROFILESDLG_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kprofiles.h"

class KWlanInterface;

class KProfilesDlg : public KProfiles
{
    Q_OBJECT

    public:
        KProfilesDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~KProfilesDlg();
        /*$PUBLIC_FUNCTIONS$*/

    public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void          scan();
        virtual void          deleteProfile();
        virtual void          editProfile();
        virtual void          newProfile();
        void setInterface (KWlanInterface *interface);
        void updateProfiles();
        
    signals:
        void sigNewProfile();
        void sigEditProfile(QString Profile);
        void sigDeleteProfile(QString profile);
        void sigScan();
    protected:
        /*$PROTECTED_FUNCTIONS$*/

    protected slots:
        /*$PROTECTED_SLOTS$*/
        
    private:
        KWlanInterface *m_interface;
    

};

#endif

