#ifndef KWLANINTERFACE_H
#define KWLANINTERFACE_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kwlan.h"
#include "wpa_ctrl.h"
#include "wpamsg.h"
#include "kuserdatarequestdlg.h"
#include "configuration.h"
#include "kwlansuprocess.h"


#include <kapplication.h>
#include <qsocketnotifier.h>
#include <wlanlib.h>
#include <arpa/inet.h>
#include <linux/netdevice.h>

class QString;
class QStringList;
class KTempFile;
class KProcess;
class KEventHistoryDlg;
class KScanDlg;
class KWlanTrayWin;

class KWlanInterface  : public QObject
{
    Q_OBJECT
    public:
        KWlanInterface();
        ~KWlanInterface();
        enum InterfaceState
        {
            UNKNOWN_STATE = -1,
            NOT_EXISTING  = 0,
            NOT_AVAILABLE = 1,
            AVAILABLE     = 2,
            RX_TRAFFIC    = 4,
            TX_TRAFFIC    = 8
        };

        enum InterfaceType
        {
            UNKNOWN_TYPE = -1,
            ETHERNET = 0,
            PPP = 1
        };
        void setType( int type )
        {
            m_type = type;
        }

        int getType()
        {
            return m_type;
        }

        void setState( int state )
        {
            m_state = state;
        }

        int getState()
        {
            return m_state;
        }
        interfaceData getInterfaceData()
        {
            if ( m_interfaceData.wirelessDevice && m_wirelessData.radioOff )
            m_interfaceData.connected = FALSE;
            return m_interfaceData;
        }
        wirelessData getWirelessData()
        {
            return m_wirelessData;
        }
        QString getCurrentProfile()
        {
            return m_ssid;
        }
        QString getConfFile()
        {
            return m_confFile;
        }
        Configuration *getConfiguration()
        {
            return m_configuration;
        }
        void setConfiguration(Configuration *config)
        {
            m_configuration = config;
        }
        bool hasControlConnection()
        {
            if (m_controlConnection) return TRUE;
            return FALSE;
        }
        wpa_ctrl *getControlConnection()
        {
            return m_controlConnection;
        }
        bool getWpaStarted()
        {
            return m_wpaStarted;
        }
        bool profileActivateNonWpa(QString ssid);
        bool profileActivateWpa(QString ssid);
        void startScriptAfterConnect();
        void setNetworkSettings();
        void checkType();
        
    public slots:
        void init(QString interface);
        void slotWpaStatusChanged(bool status);
        int  openControlConnection();
        void checkConnection();
        int  ctrlRequest(const char *command, char *bur, size_t *buflen);
        bool hasProfiles();
        QStringList listProfiles();
        QStringList listWpaProfiles();
        QStringList listNonWpaProfiles(QStringList wpaProfiles);
        int getWpaId(QString ssid);
        bool profileActivate(QString ssid);
        void releaseIpAddress();
        void getIpAddress();
        void processMessage(char *message);
        void receiveMsgs();
        void processCtrlReq( const char * request );
        void startWpa(QString driver);
        void stopWpa();
        QString getInterfaceName();
        void profileAdded();
        void ifconfigProcessExited( KProcess* process );
        void iwconfigProcessExited( KProcess* process );
        void ifconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void iwconfigProcessStdout( KProcess*, char* buffer, int buflen );
        void dhcpProcessExited(KWlanSuProcess *);
        void releaseProcessExited(KWlanSuProcess *);
        //void iwconfigProcessExited( KProcess* process );
        //void iwconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void checkConfig();
        void logViewer();
        void enableInterface(bool enable);
        void editProfiles();
        void slotScan();
        void slotNewProfile();
        void slotEditProfile(QString profile);
        void slotDeleteProfile(QString profile);

    signals:
        void wpaStatusChanged(bool started);
        void connectionStatusChanged (bool connected);
        void networksChanged();
        void ipChanged(QString ip);
        void wpaEvent( WpaMsg msg );
        void wpaEvents( WpaMsgList msgs );
        void interfaceUp(bool up);
        void interfaceGone(KWlanInterface *interface);
        void sigMessage(QString message);
        
    private:
        char *m_controlInterface,*m_controlInterfaceDir;
        wpa_ctrl *m_controlConnection, *m_monitorConnection;
        WpaMsgList m_messages;
        QSocketNotifier *m_messageNotifier;
        bool m_networkChange;
        bool m_startDhclient;
        bool m_associated;
        bool m_IpAddress;
        bool m_wpaStarted;
        bool m_useDhclient;
        bool m_useDhcpcd;
        bool m_dhcpEnabled;
        bool m_wpaWarned; // User has been warned in case of failure to connect to wpa_supplicant
        bool m_ipConfigured;
        QString m_ssid;
        QString m_staticIpAddress,  m_staticGateway, m_staticNetmask;
        QString m_staticDns1, m_staticDns2, m_domain;
        bool m_dontOverrideDns, m_dontOverrideGw;
        QStringList m_dnsSearchlist;
        QString m_dhclientPath, m_dhcpcdPath, m_wpaPath; //Path to external applications that are frequently used
        QString m_ifconfigPath, m_iwconfigPath;
        QString m_wpaConf; // path to wpa_supplicant config file for this interface;
        QTimer *m_timer;
        KUserDataRequestDlg *m_userDataRequest;
        KTempFile *resolvconf;
        interfaceData m_interfaceData;
        wirelessData m_wirelessData;
        QString m_ifconfigStdout, m_iwconfigStdout;
        KProcess *m_ifconfigProcess, *m_iwconfigProcess;
        int m_type;
        int m_state;
        QString m_confFile;
        Configuration *m_configuration;
        KEventHistoryDlg *m_eventHistory;
        KScanDlg *m_scanDlg;
        KWlanTrayWin *m_trayWin;
        bool m_useIfconfig;
        QString m_sysClassPath;
        int m_fdSock;
        struct ifreq m_devInfo;
        //KWlanSuProcess *m_dhcpProcess;
        KWlanSuProcess *m_dhcpProcess;
        KWlanSuProcess *m_releaseProcess;
        
        void parseIfconfigOutput();
        void parseIwconfigOutput();
        void updateInterfaceData( QString& config,  int type );
        void updateWirelessData( QString& config );
        void getIpData();
        void checkConfigIfconfig();
        void checkConfigSysClass();
        unsigned long readInterfaceNumValue(const char *name);
        bool openFdSocket();
        void say(QString message);
        void newInterfaceWizzard(QString interface);

    private slots:
        void cleanTemporaryFiles();
        
};

#endif
