#ifndef __KWLANMAINTRAYWIN__
#define  __KWLANMAINTRAYWIN__
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include <ksystemtray.h>
#include <qtooltip.h>

class QWidget;
class QPopupMenu;
class KWlanToolTip;
class KAction;


class KWlanMainToolTip : public QToolTip {

    public:
        KWlanMainToolTip(QWidget *parent);
        virtual ~KWlanMainToolTip();
	
    protected:
        void maybeTip(const QPoint &);
};


class KWlanMainTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KWlanMainTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KWlanMainTrayWin();
        void contextMenuAboutToShow( KPopupMenu *r );
    public slots:
        void slotHandleInterfacesMenu(int id);
        void slotSettingsMenu();
    signals:
        void aboutSelected();
        void sigMonitorInterface(QString interface, bool showWin);
    protected:
        KAction *m_quit, *m_about;
        KWlanMainToolTip *m_tooltip;
    private:
        KPopupMenu *m_interfacesMenu;
        KAction *m_settingsMenu;
  
};


#endif
