#ifndef KWLANSUPROCESS_H
#define KWLANSUPROCESS_H

#include "suprocessbase.h"

/** KWlanSuProcess: KWlan-specific su(1) process.
 *  Copyright (c) 2006 Valentine Sinitsyn <e_val@inbox.ru>. Distributed under the same terms as KWlan
 *
 *  Typical usage of this class is as follows:
 *
 *  KWlanSuProcess *command = new KWlanSuProcess(this); // Be careful when choosing the parent - su(1) process will be killed on par with it.
 *  *command << getPath("...") << arg1 << arg2;
 *  command->setDescription("..."); //Human-readable description of what command do to show in dialogs etc.
 *  command->setRestart(true); // set to false or omit altogether is you don't want to allow user to restart the task. 
 *                          // Restarting makes sense for DHCP clients who can fail due to temporary reasons.
 *  command->start();
 *
 *  KWlanSuProcess will take care of showing dialogs to the user, requesting password and deleting an object
 *  when it will be no longer needed.
 *  Unlike its parent, KWlanSuProcess can't be started in DontCare mode
 */
class KWlanSuProcess: public SuProcessBase {
  Q_OBJECT
  
  
    public:
        KWlanSuProcess(QObject *parent = 0, const char *name = 0);
        virtual ~KWlanSuProcess();
    
        virtual bool start(RunMode runmode = NotifyOnExit, Communication comm = NoCommunication);
    
        void setDescription(const QString &desc);
        void setRestart(bool restart);
    signals:
        void processExited(KWlanSuProcess *);
    
    public slots:
        void slotProcessExited(SuProcessBase *);
    
    protected:
        virtual bool getPassword(QCString &password);

    private:    
        enum PasswordStates {
            PasswordRequired = 0x01,
            PasswordEntered = 0x02,
            PasswordRefused = 0x04
        };
    
        int m_pwstate, m_keep;
        bool m_restart;
        QCString m_desc, m_password;
        QObject * m_parent;
};

#endif
