/*
 * Copyright (C) 2004 Stefano <stefano@xiaprojects.com>
 */

#include "kxdocker.h"

#include <kapplication.h>
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kxdocker", I18N_NOOP("KXDocker"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Stefano", 0, 0, "stefano@xiaprojects.com");
    about.addAuthor( "Stefano", 0, "stefano@xiaprojects.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
	
	if (!KUniqueApplication::start())
	{
		qWarning("KXDocker is already running!");
		return (0);
	}
    KUniqueApplication app;
    KXDocker *mainWin = 0;

/*
    if (app.isRestored())
    {
        //RESTORE(KXDocker);
    }
    else
    {
*/
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        mainWin = new KXDocker();
        //app.setMainWidget( mainWin );
        //mainWin->show();

        args->clear();
//    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

