/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gepillow.h"

#include <xeobject.h>
#include <xeconfiguration.h>
#include <xgdocker.h>
#include <xgicon.h>

#include <kwin.h>
#include <krootpixmap.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kwinmodule.h>
#include <kwin.h>
#include <netwm.h>

#include <qpainter.h>
#include <qbitmap.h>

XEPlugin_GEPillow::XEPlugin_GEPillow(QWidget *parent, const char *name)
 : QWidget(NULL, name)
{
	if(name!=NULL)XEObject::xPluginAdd(this);
	KWin::setType(winId(), NET::Dock);
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	NETWinInfo* info;
	info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	info->setDesktop( NETWinInfo::OnAllDesktops);
}


XEPlugin_GEPillow::~XEPlugin_GEPillow()
{
}


#include "xeplugin_gepillow.moc"


/*!
    \fn XEPlugin_GEPillow::xSetupParameter(const QString, const QString)
 */
void XEPlugin_GEPillow::xSetupParameter(const QString, const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::paintEvent( QPaintEvent *e)
 */
void XEPlugin_GEPillow::paintEvent( QPaintEvent *e)
{
	QRect rect = e->rect();
	int l=rect.left();
	int t=rect.top();
	int w=rect.width();
	int h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);

}


/*!
    \fn XEPlugin_GEPillow::xRefresh
 */
void XEPlugin_GEPillow::xRefresh()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::xStart
 */
void XEPlugin_GEPillow::xStart()
{
	qWarning("void XEPlugin_GEPillow::xStart()");
	paintBuffer.resize(800,30);
	paintBuffer.fill(Qt::black);
	resize(800,30);
	//show();
}


/*!
    \fn XEPlugin_GEPillow::xStop
 */
void XEPlugin_GEPillow::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::xSetup
 */
void XEPlugin_GEPillow::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
}


/*!
    \fn XEPlugin_GEPillow::externalDrawPillow(QObject *,int,int)
 */
void XEPlugin_GEPillow::externalDrawPillow(QObject *newIcon,int x,int y)
{
	XGIcon *xGIcon=(XGIcon *)newIcon;
	/*
		QPixmap FAKEPILLOW=QPixmap::grabWindow(
					QApplication::desktop()->winId(), 
					x,
					y, 
					100,
					20)
					;
			bitBlt(xPillow,0,0,
				&FAKEPILLOW,
				0,
//				bsw,
//				bsh,
				Qt::CopyROP);
	*/
	if(!xGIcon->isTextDrawed)xGIcon->xDrawText();
	// we don't want transparency at this time than we apply the automask
	paintBuffer.fill(Qt::red);
	//setMask(xGIcon->xImgText.createAlphaMask());
	//setMask(*xGIcon->xImgText.mask());
	
	QPixmap a;
	//a.convertFromImage(xGIcon->xImgText);
	const QBitmap *ma=xGIcon->xImgText.mask();
	if(ma)setMask(*ma);
	bitBlt(&paintBuffer,0,0,
				&xGIcon->xImgText,
//				bsw,
//				bsh,
				Qt::CopyROP);
	move(x,y);
	repaint(false);
}
