/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_command.h"

#include "xeconfiguration.h"
#include "xgdocker.h"

#include "taskmanager.h"

#include <kpopupmenu.h>
#include <kiconloader.h> 
#include <krun.h>

#include <qcursor.h> 
#include <qvaluelist.h> 
#include <qdragobject.h> 


XEPlugin_Command::XEPlugin_Command(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	onClickMiddle="exec";
	onClickLeft="popup";

}


XEPlugin_Command::~XEPlugin_Command()
{
	// qWarning("XEPlugin_Command::~XEPlugin_Command()");
}


#include "xeplugin_command.moc"


/*!
    \fn XEPlugin_Command::xEventMouseClick(int icon, int x, int y, int button)
 */
void XEPlugin_Command::xEventMouseClick(int icon, int x, int y, int button)
{
//	char pippo[50];
//	sprintf(pippo,"MouseClick: [%d][%d][%d]",x,y,button);
//	qWarning(pippo);
	if(icon<0)return;
	uint TargetIcon=icon;
	if(button==Qt::LeftButton)
	{
			if(TargetIcon <ActiveConfiguration->ObjectsIcons.count())
			{
				if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks.TaskInfo!=NULL)
				{
					// check default left click action
					if((onClickLeft=="" ||onClickLeft=="popup") &&ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks.Proces.count()>1)
					{
			lastIconExec=ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec;
			// TODO: make 1 var only
			lastIcon=ActiveConfiguration->ObjectsIcons.at(TargetIcon);
						popMenuFunction(
						&ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks,
						1);
					}
					else
					{
						Task *t=(Task *)ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks.TaskInfo;
						t->activateRaiseOrIconify();
					}
				}
				else
				{
					//0.29
					// udpated
					// patch from Saurabh
					// TODO: move applet class pointer to ActiveConfiguration
					XGIcon *target=xGDocker->getObjectIcon(TargetIcon);
					if(target!=NULL
						&&
						target->xEnabledClickClass()
					)
					{
						qWarning("Run applet click");
						/*
	 					int dx,dy;
 						dx = x-icon*(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)-ActiveConfiguration->Window.borderLeft;
 						dy = y-(ActiveConfiguration->Window.borderTop);
						*/
						int dx,dy;
						double fdx,fdy;
						
						fdx=(double(x-target->xPosition.x())/target->xZoom)*ActiveConfiguration->Icons.Size;
						fdy=(double(y-target->xPosition.y())/target->xZoom)*ActiveConfiguration->Icons.Size;
						
						dx=(int)fdx;
						dy=(int)fdy;
						
						
 						target->xEventClickClass(dx,dy,button);
 						
					}
					else
					{
						qWarning(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec);
						KRun::runCommand(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec);
					}
				}
			}
	}
	
	if(button==Qt::RightButton)
	{
		if(TargetIcon <ActiveConfiguration->ObjectsIcons.count())
		{
//			if(ActiveConfiguration->ObjectsIcons.at(icon)->Tasks.TaskInfo!=NULL)
			{
			lastIconExec=ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec;
			// TODO: make 1 var only
			lastIcon=ActiveConfiguration->ObjectsIcons.at(TargetIcon);
			popMenu(
				&ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks
				);
				/*
				Task *t=(Task *)ActiveConfiguration->ObjectsIcons.at(icon)->Tasks.TaskInfo;
				t->activateRaiseOrIconify();
				*/
				//xEventReset(x,y);
				
				//0.27
				// moved to the popup code
				//xGDocker->xRestore();
			}
//			else
//			{
			//qWarning(ActiveConfiguration->ObjectsIcons.at(icon)->Actions.onClickExec);
			//KRun::runCommand(ActiveConfiguration->ObjectsIcons.at(icon)->Actions.onClickExec);
//			}
		
		}
	}	
	
	if(button==Qt::MidButton)
	{
		if(TargetIcon <ActiveConfiguration->ObjectsIcons.count())
		{
			// Multigroup parser
			clickMiddle(TargetIcon);
		}
	}
	
}


/*!
    \fn XEPlugin_Command::xStart()
 */
void XEPlugin_Command::xStart()
{
#ifndef ENABLE_FINAL
	qWarning("Command::xStart");
#endif
	connect(xGDocker,SIGNAL(xEventMouseClick(int,int,int,int)),
		this,SLOT(xEventMouseClick(int,int,int,int)));
	connect(xGDocker,SIGNAL(xEventMouseWheel(int,int,int,int)),
		this,SLOT(xEventMouseWheel(int,int,int,int)));
	connect(xGDocker,SIGNAL(dropIcon(int,QDropEvent*)),
		this,SLOT(dropIcon(int,QDropEvent*)));
	
}


/*!
    \fn XEPlugin_Command::xSetup()
 */
void XEPlugin_Command::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("Mouse::xSetup");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	preloadXMLcfg();
}


/*!
    \fn XEPlugin_Command::xStop()
 */
void XEPlugin_Command::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Command::xEventMouseWheel(int,int,int,int)
 */
void XEPlugin_Command::xEventMouseWheel(int icon, int x, int y, int button)
{
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"MouseWheel: [%d][%d][%d]",x,y,button);
	qWarning(pippo);
#endif
	if(icon>=0 && icon <ActiveConfiguration->ObjectsIcons.count())
	{
	
		QPtrList<XSGObjectIcon> RollingList;
		int lastIndex=0;
		for(int k=0;k<ActiveConfiguration->RollingIcons.count();k++)
		{
			if(
				ActiveConfiguration->RollingIcons.at(k)->Info.Group
				==
				ActiveConfiguration->ObjectsIcons.at(icon)->Info.Group
			)
			 {
			 	RollingList.append(ActiveConfiguration->RollingIcons.at(k));
			 	if(ActiveConfiguration->RollingIcons.at(k)==
				 	ActiveConfiguration->ObjectsIcons.at(icon))lastIndex=RollingList.count()-1;
			 }
		}	
		if(RollingList.count()<2)return;
		if(button==1)
		{
			lastIndex++;
		}
		if(button==2)
		{
			lastIndex--;
			if(lastIndex<0)lastIndex=RollingList.count()-1;
		}
		lastIndex=(lastIndex)%RollingList.count();
		ActiveConfiguration->ObjectsIcons.replace(icon,RollingList.at(lastIndex));
		
		xGDocker->reloadIcon(icon);
	}
}

//#include <kicon.h> 
/*!
    \fn XEPlugin_Command::popMenu(const Task *)
 */
void XEPlugin_Command::popMenu(XSCfgTasks *Process)
{
	popMenuFunction(Process,0);
}

/*!
    \fn XEPlugin_Command::popMenuPost()
 */
void XEPlugin_Command::popMenuPost()
{
	
	if(lastProcess)
	{
		//lastProcess->PopupMenu->popup(QCursor::pos());
		//lastProcess->PopupMenu->exec(QCursor::pos());
	QPoint mc=QCursor::pos();
	mc.setX(mc.x()-40);
	mc.setY(mc.y()-5);
	lastProcess->PopupMenu->exec(mc);
		lastProcess=NULL;
		QTimer::singleShot(100,this,SLOT(popMenuPost()));
	}
	else {
		xGDocker->xRestore();
		QTimer::singleShot(50,xGDocker,SLOT(xSendToBackground()));
		//xGDocker->xSendToBackground();
		//xGDocker->lower();
	}
}


/*!
    \fn XEPlugin_Command::RunLastCmd()
 */
void XEPlugin_Command::RunLastCmd()
{
	qWarning(QString("Running: %1").arg(lastIconExec));
	KRun::runCommand(lastIconExec);
}

/*!
    \fn XEPlugin_Command::clickMiddle(int iconIndex)
 */
void XEPlugin_Command::clickMiddle(int icon)
{
	if(onClickMiddle=="exec")clickMiddleExec(icon);
	if(onClickMiddle=="explode")clickMiddleExplode(icon);
}


/*!
    \fn XEPlugin_Command::closeAll()
 */
void XEPlugin_Command::closeAll()
{
	if(lastProcess!=NULL)
	{
		qWarning("xeplugin_command.cpp:316 Closing all windows, it may crash if you have prev closed it!!!!!");
		
		for(int i=0;i<lastProcess->Proces.count();i++)
		{
			
			Task *ti=(Task *)lastProcess->Proces.at(i);
			qWarning(ti->name());
			ti->close();
		}
	}
}


/*!
    \fn XEPlugin_Command::maximizeAll()
 */
void XEPlugin_Command::maximizeAll()
{
	if(lastProcess!=NULL)
	{
#ifndef ENABLE_FINAL
		qWarning("xeplugin_command.cpp:345");
#endif		
		for(int i=0;i<lastProcess->Proces.count();i++)
		{
			
			Task *ti=(Task *)lastProcess->Proces.at(i);
			qWarning(ti->name());
			ti->maximize();
		}
	}
}


/*!
    \fn XEPlugin_Command::minimizeAll()
 */
void XEPlugin_Command::minimizeAll()
{
	if(lastProcess!=NULL)
	{
#ifndef ENABLE_FINAL
		qWarning("xeplugin_command.cpp:365");
#endif
		
		for(int i=0;i<lastProcess->Proces.count();i++)
		{
			
			Task *ti=(Task *)lastProcess->Proces.at(i);
#ifndef ENABLE_FINAL
			qWarning(ti->name());
#endif
			ti->iconify();
		}
	}
}


/*!
    \fn XEPlugin_Command::KeepInDock()
 */
void XEPlugin_Command::KeepInDock()
{
	if(lastIcon!=NULL)
	{
		if(lastIcon->Info.className=="xTaskManager")
		{
			lastIcon->Info.className="GIcon";
		}
		else
		{
			lastIcon->Info.className="xTaskManager";
		}
	}
}


/*!
    \fn XEPlugin_Command::xGetParameter(const QString,QString&)
 */
void XEPlugin_Command::xGetParameter(const QString vname ,QString& vvalue)
{
	// 0.30
	if(vname=="onClickMiddle")
	{
		vvalue=onClickMiddle;
	}
	if(vname=="onClickLeft")
	{
		vvalue=onClickLeft;
	}
}


/*!
    \fn XEPlugin_Command::xGetParameterList(QStringList*)
 */
void XEPlugin_Command::xGetParameterList(QStringList*a)
{
	//0.30
	a->append("onClickMiddle");
	a->append("onClickLeft");

}


/*!
    \fn XEPlugin_Command::activated(int)
 */
void XEPlugin_Command::activated(int mID)
{
	if(lastIcon)
	{
		for(int a=0;a<lastIcon->Actions.ActionList.count();a++)
		{
			// now supporting only exec action
			QString aAction=lastIcon->Actions.ActionList.item(a).toElement().attribute("action");
		if(aAction.isNull() || aAction=="" ||aAction=="exec")
		{
			int mIDMenu=QString(
				lastIcon->Actions.ActionList.item(a).toElement().attribute("MenuTmpID")
				).toInt();
			if(mID==mIDMenu)
			{
				QString aExe=lastIcon->Actions.ActionList.item(a).toElement().attribute("data");
				qWarning(QString("Running: %1").arg(aExe));
				KRun::runCommand(aExe);
				return;
			}
		}
		}	
	}
}


#include <qdragobject.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
/*!
    \fn XEPlugin_Command::dropIcon(int,QDropEvent*)
 */
void XEPlugin_Command::dropIcon(int icon,QDropEvent*event)
{
	QString basket;
	if(QTextDrag::decode (event, basket)==true)
	{
		if(icon<0)return;
		uint TargetIcon=icon;
		if(TargetIcon <ActiveConfiguration->ObjectsIcons.count())
		{
			qWarning(QString("(%1)[%1][%1] %1").arg(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.Name).arg(event->pos().x()).arg(event->pos().y()).arg(basket));
			
			if(0)
			{
				dropIconAddIcon(icon,event);
			}
			else
			{
	QString name;
	QStringList lst;
	QUriDrag::decodeLocalFiles(event, lst);
	name=lst[0];
	int pos=name.findRev(".desktop", -1);
	basket="";
	if(pos!=-1)
	{
		KSimpleConfig *desktopfile;
		desktopfile = new KSimpleConfig(lst[0], TRUE);
		desktopfile->setGroup("Desktop Entry");
		if(desktopfile->readEntry("Type")=="Link")
		{
			basket=desktopfile->readEntry("URL");
		}
		else if(desktopfile->readEntry("Type")=="Application")
		{
			dropIconAddIcon(icon,event);
			return;
		}
		else
		{
			basket=desktopfile->readEntry("Exec");
		}
		
		delete(desktopfile);
	}
	else
	{
		pos=name.findRev("/", -1);
		if(pos!=-1)
		{
			name.remove(1, pos);
			name.remove("/", TRUE);
		}
		basket=lst[0];
		
	}
			qWarning(basket);
			if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onDropExec=="")
			{
			ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onDropExec=ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec+" \"%1\"";
			}
			qWarning(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onDropExec.arg(basket));
			KRun::runCommand(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onDropExec.arg(basket));

			}

		}
	}

}


/*!
    \fn XEPlugin_Command::dropIconAddIcon(int,XSGObjectIcon *)
 */
void XEPlugin_Command::dropIconAddIcon(int TargetIcon,QDropEvent*event)
{

			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());

	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
	
	QString className;
	QString fileName;
	QString groupName;
	QString onClickExec;
	QString overText;
	QString newImg;
	

	QString name;
	QStringList lst;
	QUriDrag::decodeLocalFiles(event, lst);
	name=lst[0];
	int pos=name.findRev(".desktop", -1);
	if(pos!=-1)
	{
		KSimpleConfig *desktopfile;
		desktopfile = new KSimpleConfig(lst[0], TRUE);
		desktopfile->setGroup("Desktop Entry");
		name=		desktopfile->readEntry("Name");
		onClickExec=	desktopfile->readEntry("Exec");
		newImg=		desktopfile->readEntry("Icon");
		overText=	desktopfile->readEntry("GenericName");
		if(overText=="")
		{
			overText=	desktopfile->readEntry("Comment");
		}
		groupName=		desktopfile->readEntry("Categories");
		delete(desktopfile);
	}
	else
	{
		pos=name.findRev("/", -1);
		if(pos!=-1)
		{
			name.remove(1, pos);
			name.remove("/", TRUE);
		}
	
		onClickExec=lst[0];
		newImg=name;
		overText=name;
		groupName=name;
	}
	
	if(name=="")
	{
		name=lst[0];
	}
	if(groupName=="")
	{
		groupName=name;
	}
	if(overText=="")
	{
		overText=name;
	}
	
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.className!="GSeparator")
	{
	groupName=ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.Group;
	}
	
	className="GIcon";
	
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	
	addedCfg->Tasks.Proces.clear();
	
	addedCfg->Info.className=className;
	addedCfg->Info.fileName=fileName;
	addedCfg->Info.Name=name;
	addedCfg->Info.Group=groupName;
	addedCfg->Actions.onClickExec=onClickExec;
	addedCfg->Actions.onDropExec=onClickExec+" \"%1\"";
	addedCfg->OverText=overText;
	addedCfg->Images.imgFileName=newImg;
	addedCfg->Images.imgFileArrow="arrow.png";
	addedCfg->Images.imgFileDrop="drop.png";
	
	addedCfg->Tasks.WindowTitle.append(overText);
	addedCfg->Tasks.TaskName.append(name);
	addedCfg->Tasks.ClassName.append(name);
	
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.TaskInfo=NULL;
	
	// check for existent icons
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Name==ActiveConfiguration->RollingIcons.at(i)->Info.Name)
		{
		/*
			// we only update the image:
			changeImageByName(addedCfg->Info.Name,addedCfg->Images.imgFileName);
		*/
			delete addedCfg;
			return;
		}
	}
	
	ActiveConfiguration->RollingIcons.append(addedCfg);
	
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Group==ActiveConfiguration->ObjectsIcons.at(i)->Info.Group)return;
	}
	
	ActiveConfiguration->ObjectsIcons.append(addedCfg);
	xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);


}


/*!
    \fn XEPlugin_Command::xGetInfo(QStringList &)
 */
void XEPlugin_Command::xGetInfo(QStringList &)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Command::RunLastdcopClose()
 */
void XEPlugin_Command::RunLastdcopClose()
{
	if(lastIcon)
	{
		if(lastIcon->Tasks.dcopClose=="")
		{
			if(lastIcon->Tasks.dcopName.count()<1)lastIcon->Tasks.dcopName.append(lastIcon->Info.Name);
			QString TaskName=lastIcon->Tasks.dcopName[0];
			
			lastIcon->Tasks.dcopClose="dcop "+TaskName+" MainApplication-Interface quit";
		}
		qWarning(QString("Running: %1").arg(lastIcon->Tasks.dcopClose));
		KRun::runCommand(lastIcon->Tasks.dcopClose);
	}
}


/*!
    \fn XEPlugin_Command::clickMiddleExec(int)
 */
void XEPlugin_Command::clickMiddleExec(int icon)
{
	uint TargetIcon=icon;
	if(TargetIcon <ActiveConfiguration->ObjectsIcons.count())
	{
		//0.29
		// udpated
		// patch from Saurabh
		// TODO: move applet class pointer to ActiveConfiguration
		XGIcon *target=xGDocker->getObjectIcon(TargetIcon);
		if(target!=NULL
			&&
			(target->xEnabledClickClass() &2)
		)
		{
			qWarning("Run applet click");
			/*
			int dx,dy;
			dx = x-icon*(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)-ActiveConfiguration->Window.borderLeft;
			dy = y-(ActiveConfiguration->Window.borderTop);
			*/
			int dx,dy;
			double fdx,fdy;
/*			
			fdx=(double(x-target->xPosition.x())/target->xZoom)*ActiveConfiguration->Icons.Size;
			fdy=(double(y-target->xPosition.y())/target->xZoom)*ActiveConfiguration->Icons.Size;
			
			dx=fdx;
			dy=fdy;

			target->xEventClickClass(dx,dy,button);
*/			
		}
		else
		{
			qWarning(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec);
			KRun::runCommand(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec);
		}
	}
}


/*!
    \fn XEPlugin_Command::clickMiddleExplode(int)
 */
void XEPlugin_Command::clickMiddleExplode(int icon)
{
	QPtrList<XSGObjectIcon> RollingList;
	int lastIndex=0;
	for(int k=0;k<ActiveConfiguration->RollingIcons.count();k++)
	{
		if(
			ActiveConfiguration->RollingIcons.at(k)->Info.Group
			==
			ActiveConfiguration->ObjectsIcons.at(icon)->Info.Group
		)
			{
			RollingList.append(ActiveConfiguration->RollingIcons.at(k));
			if(ActiveConfiguration->RollingIcons.at(k)==
				ActiveConfiguration->ObjectsIcons.at(icon))lastIndex=RollingList.count()-1;
			}
	}	
	if(RollingList.count()<2)return;
	
	// Ok than now we can check if you have already dropped the group
	QValueList<int> DroppedList;
	for(int dropped=0;dropped<ActiveConfiguration->ObjectsIcons.count();dropped++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(icon)->Info.Group
			==
		ActiveConfiguration->ObjectsIcons.at(dropped)->Info.Group
		)
		{
			if(dropped==icon)continue;
			DroppedList.append((dropped));
		}
	}
	if(DroppedList.count()>0)
	{
		// we have to remove the others
		for(int dropme=DroppedList.count()-1;dropme>=0;dropme--)
		{
			xGDocker->iconRemove(DroppedList[(dropme)]);
		}
		return;
	}
#ifndef ENABLE_FINAL
	
	qWarning("xeplugin_command.cpp:277");
#endif
	for(int addme=0;addme<RollingList.count();addme++)
	{
		if(lastIndex==addme)continue;
		/*
		if(lastIndex>addme)
		ActiveConfiguration->ObjectsIcons.insert(icon-1,RollingList.at(addme));
		*/
		ActiveConfiguration->ObjectsIcons.insert(icon,RollingList.at(addme));
		xGDocker->xEventTaskAppend(icon);
	}
}


/*!
    \fn XEPlugin_Command::xSetupParameter(const QString, const QString)
 */
void XEPlugin_Command::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="onClickMiddle")
	{
		onClickMiddle=vvalue;
		// refreshing XML Data
		updateXMLcfg(vname);
	}
	if(vname=="onClickLeft")
	{
		onClickLeft=vvalue;
		// refreshing XML Data
		updateXMLcfg(vname);
	}
}


/*!
    \fn XEPlugin_Command::updateXMLcfg(const QString sName)
 */
void XEPlugin_Command::updateXMLcfg(const QString sName)
{
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
		
		// update xml configuration
		if(sName=="onClickMiddle")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("onClickMiddle",onClickMiddle);
		}
		if(sName=="onClickLeft")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("onClickLeft",onClickLeft);
		}
		}
	}
}


void XEPlugin_Command::preloadXMLcfg()
{
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
#ifndef ENABLE_FINAL
		qWarning(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
#endif
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
		
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
			xSetupParameter("onClickMiddle",
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickMiddle", "exec")
			);
			xSetupParameter("onClickLeft",
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickLEft", "popup")
			);
		}
		else
		{
			// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		}
			break;
		}
	}

}


/*!
    \fn XEPlugin_Command::RunLastKill()
 */
void XEPlugin_Command::RunLastKill()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Command::popMenuFunction(XSCfgTasks *Process, int isSmall)
 */
inline void XEPlugin_Command::popMenuFunction(XSCfgTasks *Process, int isSmall)
{
	KIconLoader KDEIcons;
	// TODO: have we to clear the popup menu every time?
	if(Process->PopupMenu==NULL)
	{
		// Icon don't have the popup
		// we create new one
		Process->PopupMenu=new KPopupMenu();
		connect(Process->PopupMenu,SIGNAL(activated(int)),this,SLOT(activated(int)));
	}
//	else
	{
	Process->PopupMenu->clear();

	///7qWarning("895");

	// Starting populating menu
	// 0.33
	if(!isSmall)
	{

	// 0.30
	if((lastIcon&& lastIcon->Tasks.dcopReady )||(Process->Proces.count()>0)||lastIcon->Tasks.forceRunning)
	{
	
		Process->PopupMenu->insertTitle(KDEIcons.loadIcon(lastIcon->Images.imgFileName,KIcon::Small),"Application");
	}
	//qWarning("908");

	// 0.29
	// application dcop menu
	if(lastIcon&& lastIcon->Tasks.dcopReady)
	{
	
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("exit",KIcon::Small),QString("Quit  %1").arg(lastIcon->OverText),this,SLOT(RunLastdcopClose()));
	}
	if(Process->Proces.count()>0)
	{
		// xkill
		Task *ti=(Task *)Process->Proces.at(0);
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("xkill",KIcon::Small),QString("Force close %1").arg(ti->name()),ti,SLOT(close()));
	}

	}
	///7qWarning("926");

	// 0.33
	if(!isSmall)
	{
	// Action menu
	Process->PopupMenu->insertTitle(KDEIcons.loadIcon("window_new",KIcon::Small),"Actions");
	}


	Process->PopupMenu->insertItem(KDEIcons.loadIcon("launch",KIcon::Small),"Open New Window",this,SLOT(RunLastCmd()));
	
	// 0.33
	if(!isSmall)
	{
		for(int a=0;a<lastIcon->Actions.ActionList.count();a++)
		{
			// now supporting only exec action
			QString aAction=lastIcon->Actions.ActionList.item(a).toElement().attribute("action");
			lastIcon->Actions.ActionList.item(a).toElement().removeAttribute("MenuTmpID");
			if(aAction.isNull() || aAction=="" ||aAction=="exec")
			{
				QString aIcon=lastIcon->Actions.ActionList.item(a).toElement().attribute("image");
				if(aIcon.isNull() || aIcon=="" )aIcon="run";
				QString aInfo=lastIcon->Actions.ActionList.item(a).toElement().attribute("info");
				QString aExe=lastIcon->Actions.ActionList.item(a).toElement().attribute("data");
				if(aExe.isNull() || aExe=="" )continue;
				if(aInfo.isNull() || aInfo=="" )aInfo=aExe;
				int mID=Process->PopupMenu->insertItem(KDEIcons.loadIcon(aIcon,KIcon::Small),aInfo);
				lastIcon->Actions.ActionList.item(a).toElement().setAttribute("MenuTmpID",mID);
			}
			
		}
		if(lastIcon && lastIcon->PluginPopupMenu)
		{
			if(lastIcon->Info.className!="GIcon")
			{
				Process->PopupMenu->insertItem(
					KDEIcons.loadIcon("viewmag",KIcon::Small),"Plugin Actions",lastIcon->PluginPopupMenu);

				QObject *PluginClass=XEObject::xFindObject(lastIcon->Info.className);
				int idIcon=ActiveConfiguration->ObjectsIcons.find(lastIcon);
				if(PluginClass!=NULL && idIcon>=0)
				{
					Process->PopupMenu->insertItem(
						KDEIcons.loadIcon("kcontrol",KIcon::Small),
						"Configure Plugin",
						// 0.34
						//PluginClass
						xGDocker->getObjectIcon(idIcon)
						,SLOT(xRunConfiguratorClass()));
				}
			}
		}
	}

	lastProcess=NULL;
	
	if(Process->Proces.count()>0)
	{
		// 0.33
		if(!isSmall)
		{
			Process->PopupMenu->insertTitle(KDEIcons.loadIcon("window_new",KIcon::Small),"Global actions");
		
			Process->PopupMenu->insertItem(
				KDEIcons.loadIcon("window_fullscreen",KIcon::Small),
				"Maximize",
				this,SLOT(maximizeAll()));
			
			Process->PopupMenu->insertItem(
				KDEIcons.loadIcon("window_nofullscreen",KIcon::Small),
				"Minimize",
				this,SLOT(minimizeAll()));
			Process->PopupMenu->insertItem(
				KDEIcons.loadIcon("remove",KIcon::Small),
				"Close",
				this,SLOT(closeAll()));
		}

		Process->PopupMenu->insertTitle(KDEIcons.loadIcon("window_list",KIcon::Small),"Window list");
		lastProcess=Process;
		for(int i=0;i<Process->Proces.count();i++)
		{
			Task *ti=(Task *)Process->Proces.at(i);
			qWarning(ti->name());
			Process->PopupMenu->insertItem(ti->pixmap(),ti->name(),ti,SLOT(activateRaiseOrIconify()));
		}
	}

	// 0.33
	if(!isSmall)
	{

		Process->PopupMenu->insertTitle(KDEIcons.loadIcon("configure",KIcon::Small),"Configure");
		if(lastIcon->Info.className!="xTaskManager")
		{
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("unlock",KIcon::Small),"make float",
			this,SLOT(KeepInDock()));
		}
		else
		{
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("lock",KIcon::Small),"keep in dock",
			this,SLOT(KeepInDock()));
		
		}

		Process->PopupMenu->insertItem(KDEIcons.loadIcon("trashcan_empty",KIcon::Small),"remove from dock",
			this,SLOT(RunLastRemoveIcon()));


		// 0.33
		// KXDocker menu like the tray
		/*
		Process->PopupMenu->insertTitle(KDEIcons.loadIcon("kxdocker",KIcon::Small),"KXDocker");
		if(XEObject::xFindObject("xConfigurator")!=NULL)
		{
		//Process->PopupMenu->insertTitle(loadIcon("configure"),"Setup docker");
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("iconthemes",KIcon::Small),"Configurator",
			XEObject::xFindObject("xConfigurator"),SLOT(xConfigure()));
		}
		if(xGDocker!=NULL)
		{
		//Process->PopupMenu->insertTitle(loadIcon("configure"),"Setup docker");
		Process->PopupMenu->insertItem(KDEIcons.loadIcon("close",KIcon::Small),"Quit",
			xGDocker,SLOT(close()));
		}
		*/

	}

	//qWarning("1042");

	/**************************************************/
	// 0.27 make it async
	// does not work
	//xGDocker->xSendToBackground();
	lastProcess=Process;
/*	QPoint mc=QCursor::pos();
	mc.setX(mc.x()-40);
	mc.setY(mc.y()-5);
*/
	//Process->PopupMenu->popup(mc);
	//QTimer::singleShot(10,this,SLOT(popMenuPost()));
	//it lock the application
	//Process->PopupMenu->exec(mc);
	//Process->PopupMenu->exec(QCursor::pos());
	QTimer::singleShot(200,this,SLOT(popMenuPost()));
	//xGDocker->xRestore();
	}
}


/*!
    \fn XEPlugin_Command::RunLastRemoveIcon()
 */
void XEPlugin_Command::RunLastRemoveIcon()
{
	if(lastIcon)
	{
		int idx=ActiveConfiguration->ObjectsIcons.find(lastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->iconRemove(idx);
		}
		ActiveConfiguration->RollingIcons.remove(lastIcon);
	}
}
