/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <xeplugin_gaclock.h>
#include <xgicon.h>

#include <kstandarddirs.h>
#include <klocale.h>
#include <kglobalsettings.h> 
#include <qpixmap.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qfile.h>


XEPlugin_GAClock::XEPlugin_GAClock(QObject *parent, const char *name)
 : XEPlugin_GApplet(parent, name)
{
}


XEPlugin_GAClock::~XEPlugin_GAClock()
{
}


#include "xeplugin_gaclock.moc"


/*!
    \fn XEPlugin_GAClock::dirty(const QString &)
 */
void XEPlugin_GAClock::dirty()
{
    xRefresh();
    QTimer::singleShot( 60*1000, this, SLOT(dirty()) );
}


/*!
    \fn XEPlugin_GAClock::xPaint()
 */
void XEPlugin_GAClock::xPaint()
{

	// 0.29
	// GClock is a DIGITAL clock not analog....
	// check out the new GAClock for analog themes
	if(xGIcon==NULL)return;
	
	QString ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/clock.png";
	QFile a(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/clock.png";
	}
	QPixmap Pixmap;
	Pixmap.load(::locate("data",ClockPaths));
	xImgSource=Pixmap.convertToImage();
	
	char filename[50];
	
	// 0.29
	// GClock is a DIGITAL clock not analog....
	/*	
	// patch from Filip (thanks!!!!!!!!!)
if(QTime::currentTime().hour()>=12){
sprintf(filename,"gclock_h%d.png",(QTime::currentTime().hour()-12)*5+((QTime::currentTime().minute())/ 12));
}
else
{
sprintf(filename,"gclock_h%d.png",(QTime::currentTime().hour())*5+((QTime::currentTime().minute()) / 12));
}
	*/
	sprintf(filename,"gclock_h%d.png",(QTime::currentTime().hour()));
	
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
		a.setName(ClockPaths);
		if(!a.exists() || ClockPaths==QString::null)
		{
			//sprintf(filename,"gclock_h%d.png",QTime::currentTime().hour());
			ClockPaths=IconsPath;
			ClockPaths=ClockPaths+"/"+filename;
			a.setName(ClockPaths);
			
			if(!a.exists() || ClockPaths==QString::null)
			{
				ClockPaths="kxdocker/plugins/gclock/";
				ClockPaths=ClockPaths+filename;
				a.setName(ClockPaths);
				if(!a.exists() || ClockPaths==QString::null)
				{
					//sprintf(filename,"gclock_h%d.png",QTime::currentTime().hour());
					ClockPaths="kxdocker/plugins/gclock/";
					ClockPaths=ClockPaths+filename;
				}
			}
		}
	}
	
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	
	QImage iPixmap=Pixmap.convertToImage();
	bitBlt(&xImgSource,0,0,&iPixmap,0,Qt::CopyROP);
	
	ClockPaths="kxdocker/plugins/gclock/";
	////////////////////////////////////
	sprintf(filename,"gclock_m%d.png",QTime::currentTime().minute());
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
	}
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	iPixmap=Pixmap.convertToImage();
	bitBlt(&xImgSource,0,0,&iPixmap,0,Qt::CopyROP);
	
	ClockPaths="kxdocker/plugins/gclock/";
	sprintf(filename,"gclock_c%d.png",QDate::currentDate().day());
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
	}
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	iPixmap=Pixmap.convertToImage();
	bitBlt(&xImgSource,0,0,&iPixmap,0,Qt::CopyROP);
	
	sprintf(filename,"%d:%02d %d/%d/%d",
		QTime::currentTime().hour(),
		QTime::currentTime().minute(),
		QDate::currentDate().month(),
		QDate::currentDate().day(),
		QDate::currentDate().year()
		);
	
	xGIcon->xSetText(filename);
	
}


/*!
    \fn XEPlugin_GAClock::xStart()
 */
void XEPlugin_GAClock::xStart()
{
	//qWarning("XEPlugin_GAClock::xStart()");
	if(xGIcon!=NULL){
	
	if(xGIcon->iconConfiguration->PluginConfiguration.count()>0)
	{
		IconsPath=
			xGIcon->iconConfiguration->PluginConfiguration
			.item(0).toElement().attribute("path");
	}
	}
	QTimer::singleShot( 60*1000, this, SLOT(dirty()) );
	XEPlugin_GApplet::xStart();
}


/*!
    \fn XEPlugin_GAClock::void xGetParameter(const QString, QString&)
 */
void XEPlugin_GAClock::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
	vvalue=	IconsPath;
	}
}


/*!
    \fn XEPlugin_GAClock::void xSetupParameter(const QString, const QString)
 */
void XEPlugin_GAClock::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="path")
	{
		IconsPath=vvalue;
	}
	// refreshing XML Data
	if(xGIcon!=NULL){
	if(xGIcon->iconConfiguration->PluginConfiguration.count()>0)
	{
		xGIcon->iconConfiguration->PluginConfiguration
			.item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		qWarning("Error: loaded xml doesn't store all data:");
		qWarning("void XEPlugin_GAClock::xSetupParameter(const QString vname, const QString vvalue)");
		
		//qWarning("Trying to add this parameter...");
		
	}
	}
}


/*!
    \fn XEPlugin_GAClock::xGetParameterList(QStringList *)
 */
void XEPlugin_GAClock::xGetParameterList(QStringList *a)
{
	a->append("path");
}


/*!
    \fn XEPlugin_GAClock::xGetInfo(QStringList &)
 */
void XEPlugin_GAClock::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version=KXDOCKERVERSION;
	Version=Version+"-0.4";
	PluginInformations.append("KXDocker GClock");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append(KXDOCKERDATE); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;

}
