/***************************************************************************
                          kxe_viewelement.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewelement.h"
#include "xml_base.h"
#include "tablewidget.h"

#include <qmultilinedit.h>

KXE_ViewElement::KXE_ViewElement( QWidget * pParent, const char * pszName )
	: QSplitter( Qt::Vertical, pParent, pszName )
{
	m_pTableAttributes = new TableWidget( 0, 2, this, "table of element attributes");

	m_pEditPlainXML = new QMultiLineEdit( this, "plain XML" );
	m_pEditPlainXML->setReadOnly(true);
}

void KXE_ViewElement::slotChange( XmlElement * const pElement )
{
	// change attribute view
	m_pTableAttributes->slotChange(pElement);

	// change plain XML view
	QString szPlainXML;
	pElement->save(szPlainXML,0);
	m_pEditPlainXML->setText(szPlainXML);
}