/***************************************************************************
                          kxmleditorpart.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORPART_H
#define KXMLEDITORPART_H

#include <kparts/part.h>
#include <kparts/browserextension.h>

#include "kxe_treeview.h"

class QTabWidget;
class KXE_ViewElement;
class KXE_ViewProcInstr;
class QMultiLineEdit;
class XmlElement;
class XmlContentsItem;
class XmlProcessingInstruction;
class KAction;
class KToolBarPopupAction;
class KXmlEditorComboAction;

/** This is the KPart of KXMLEditor. */
class KXMLEditorPart : public KParts::ReadOnlyPart
{
		Q_OBJECT

	public:
		/** Creates the actions, the view (widgets) and changes to "begin state". */
		KXMLEditorPart( QWidget * pParent, const char * pszName );
		virtual ~KXMLEditorPart();

		/** Changes the behaviour of this part to readonly or readwrite. */
		virtual void setReadWrite( bool fReadWrite );

	public slots:

		/** displays search dialog and finds string in this tree view */
		void slotEditFind() { m_pViewTree->slotEditFind(); }
		/** finds next occurence of string in this tree view */
		void slotEditFindNext() { m_pViewTree->slotEditFindNext(); }
		void slotEditDeselect();
		/** Selects the selected item's parent item. */
		void slotViewNodeUp() { m_pViewTree->slotViewNodeUp(); }
		/** Expands the selected tree item's subtree. */
		void slotViewExpNode() { m_pViewTree->slotViewExpNode(-1); }
		/** Expands the selected tree item's subtree to the given level. */
		void slotViewExpNode( int nLevel ) { m_pViewTree->slotViewExpNode(nLevel); }
		/** Collapses the selected tree item's subtree. */
		void slotViewColNode() { m_pViewTree->slotViewColNode(-1); }
		/** Collapses the selected tree item's subtree to the given level. */
		void slotViewColNode( int nLevel ) { m_pViewTree->slotViewColNode(nLevel); }
		/** toggles bookmark on the selected item */
		void slotBookmarksToggle() { m_pViewTree->slotBookmarksToggle(); }
		/** searches for the previous bookmarked item */
		void slotBookmarksPrev() { m_pViewTree->slotBookmarksPrev(); }
		/** searches for the next bookmarked item */
		void slotBookmarksNext() { m_pViewTree->slotBookmarksNext(); }
		/** shows configuration dialog (@ref OptionsDialog) */
		void slotConfigure();

		void slotPathSelected( const QString & szPath );
		void slotPathClear();


	protected:
		/** Opens the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool openFile();

		// the actions
		KAction * m_pActEditFind;
		KAction * m_pActEditFindNext;
		KAction * m_pActEditDeselect;
		KAction * m_pActViewNodeUp;
		KToolBarPopupAction * m_pActViewExpNode;
		KToolBarPopupAction * m_pActViewColNode;
		KAction * m_pActBookmarksToggle;
		KAction * m_pActBookmarksPrev;
		KAction * m_pActBookmarksNext;
		KXmlEditorComboAction * m_pActPathCombo;

	protected slots:
void started();
void completed();
void canceled();
		/** enables/disables actions depending on the given XML element and changes views  */
		void slotTreeSelectionChanged( XmlElement * );
		/** enables/disables actions and changes views */
		void slotTreeSelectionChanged( XmlContentsItem * );
		/** enables/disables actions and changes views */
		void slotTreeSelectionChanged( XmlProcessingInstruction * );
		/** enables/disables bookmark actions */
		void slotNewBookmarkStatus( bool );
		/** applies changes of the configuration and saves it to config file */
		void slotConfigurationChanged();

	private:
		/** this view displays the XML-document's tree structure */
		KXE_TreeView * m_pViewTree;
		/** the tab widget, contains: m_pViewElement, m_pViewContents */
		QTabWidget * m_pTabWidget;
		/** widget to display XML element */
		KXE_ViewElement * m_pViewElement;
		/** edit widget for contents */
		QMultiLineEdit * m_pViewContents;
		/** widget to display a proc.instr. */
		KXE_ViewProcInstr * m_pViewProcInstr;
};



/**
 * The browser extension for our part (@ref KXMLEditorPart)
 * (needed for readonly parts)
 */
class KXMLEditorBrowserExtension : public KParts::BrowserExtension
{
		Q_OBJECT

		friend class KXMLEditorPart;

	public:
		KXMLEditorBrowserExtension( KXMLEditorPart * pParent ) : KParts::BrowserExtension( pParent, "KXMLEditorBrowserExtension") {}
		virtual ~KXMLEditorBrowserExtension() {}
};

#endif
