/***************************************************************************
                          kxmleditorshell.h  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /**
 @file
 */


#ifndef KXMLEDITORSHELL_H
#define KXMLEDITORSHELL_H

#include <kparts/mainwindow.h>

class KParts::ReadWritePart;
class KXMLEditorShellIface;
class KAction;
class KXEShellManager;


/**
	@short The shell, which can contain our #KXMLEditorPart.

	It is the window that owns main user interface elements.
*/
class KXMLEditorShell : public KParts::MainWindow
{
	Q_OBJECT
	public:
		/** @short Constructor

		Creates shell and adds it into one global instance of KXEShellManager.
		@sa KXEShellManager
		*/
		KXMLEditorShell( const char * name = 0L, WFlags f = WDestructiveClose );

		/** @short Destructor

                Destroys shell. Performs also removing given shell from global instance
		of KXEShellManager.
		*/
		virtual ~KXMLEditorShell();

		/** @short Opens new file and shows it in the current shell. */
		bool openURL( const KURL & url ) ;

		/** @short Closes this shell. */
		virtual void close();

                /** @short Returns part manager object */
		KXEShellManager* manager();

		/** @short Creates new part which can be shown in the shell.
			@param parent parent object for the part*/
		static KParts::ReadWritePart* createXMLPart(QObject *parent) ;

		static KParts::ReadWritePart* createPart(QObject *parent, const QString& libName, const QString& className);

		/** @short Changes currenly shown part. */
		void setPart(KParts::ReadWritePart* pPart);

	public slots:
		/** @short Slot connected to File->New action. */
		void slotActFileNew();

		/** @short Slot connected to File->Open action. */
		void slotFileOpen();

		void slotFileOpenRecent( const KURL & url );

		/** @short Slot connected to File->Reload action. */
		void slotFileReload();

		/** @short Slot connected to action responsible for showing and hiding main toolbar.*/
		void slotToggleMainToolBar();

		/** @short Slot connected to action responsible for showing and hiding status bar.*/
		void slotToggleStatusBar();

                /** @short Slot connected to action. Shows shortcut configuration dialog.*/
		void slotConfigureKeys();

		/** @short Slot connected to action. Shows toolbar configuration dialog.*/
		void slotConfigureToolbars();

		/** @short Changes shell caption.*/
		virtual void setCaption( const QString & strCaption );

		/** @short Sends currently opened XML file over e-mail.

		The application will try to start default mail client and prepare
		new empty mail with currently opened file as an attachment.
		The file have to be saved first on a disc.
			@sa KApplication::invokeMailer()
		*/
		void mail();

		/** @short Connected to File->Close action

                Closes currently opened file, but not the shell itself. The shell
		remaines empty but active, so it's possible for the user
		to open another file in it.*/
		void slotActClose();

		/** @short slot connected to Window->Close action.
			@sa close()	*/
		void slotActWindowClose();

		/** @short slot connected to Window->Close All action. */
		void slotActWindowCloseAll();

		/** @short slot connected to Window->Close All Others action. */
    void slotActWindowCloseAllOthers();
    
		void slotActivate();

	protected:
		virtual bool queryClose();
		virtual void saveProperties( KConfig * );
		virtual void readProperties( KConfig * );

		/** @short Stores pointer to currenly shown part. */
		KParts::ReadWritePart * m_pPart;

		/** @short Action for recently opened files. */
		KRecentFilesAction * m_pActFileOpenRecent;

		/** @short Action for reloading the document currently open. */
		KAction * m_pActReload;

		/** @short Action for printing complete XML files.*/
		// L.V. moved to part. KAction* pActPrint;

		KAction* pActCloseW;
		KAction* pActCloseAllW;
		KAction* pActCloseAllO;

		/** @short DCOP interface pointer (if no such iface pointer == 0).*/
		KXMLEditorShellIface * m_pKXEShellIface;

		/** @short Stores pointer to window menu.

		 This menu is expanded everytime new shell is shown. */
		KPopupMenu* m_windowMenu;

		/** @short Returns currently shown part. */
		KParts::ReadWritePart* part() const {return m_pPart;}

		/** @short Adds this shell window to part manager for monitoring */
//		void addToManager();

	protected slots:
		/** To enable/disable actions, the way the parts browser extension wishes. */
		void slotEnableBrowserExtActions( const char * pszName, bool bEnabled );
    
		void slotBeforeWindowMenuShown();
		
		// Add URL to recent file list
		void slotAddRecentURL(const KURL &);

	private:
		/** @short Stores pointer to global instance of #KParts::PartManager */
		static KXEShellManager *s_manager;
};

#endif
