/***************************************************************************
                          kxeattributedialog.cpp  -  description
                          ----------------------
    begin                : Fre Jul 12 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxeattributedialog.h"

#include <klineedit.h>
#include <kdebug.h>
#include <klocale.h>

#include <qpushbutton.h>
#include <qlabel.h>

KXEAttributeDialog::KXEAttributeDialog( QWidget * pParent, const char * pszName, bool fModal, WFlags fl )
	: KXEAttributeDialogBase( pParent, pszName, fModal, fl )
{
  connect( m_pEditNamespace, SIGNAL(textChanged(const QString &)), this, SLOT(slotNamespaceChanged(const QString &)) );
	connect( m_pEditQName, SIGNAL(textChanged(const QString &)), this, SLOT(slotNameChanged(const QString &)) );
	connect( m_pEditValue, SIGNAL(textChanged(const QString &)), this, SLOT(slotValueChanged(const QString &)) );
}

void KXEAttributeDialog::clearDialog()
{
	m_pEditNamespace->clear();
	m_pEditQName->clear();
	m_pEditValue->clear();
}

int KXEAttributeDialog::exec()
{
	clearDialog();

  m_pBtnOK->setEnabled(false);

	m_pEditQName->setFocus();
	m_pBtnOK->setDefault(true);

	int iReturn = KXEAttributeDialogBase::exec();
	if ( iReturn == Accepted )
	{
    m_strNamespace = m_pEditNamespace->text();
    m_strQName = m_pEditQName->text();
    m_strValue = m_pEditValue->text();
	}

	return iReturn;
}

void KXEAttributeDialog::slotNameChanged(const QString & strNewName)
{
	QString strMessage = checkName(strNewName);
  if(strMessage.isEmpty())
     {
       strMessage = checkNamespace(m_pEditNamespace->text());
       if(strMessage.isEmpty())
         strMessage = checkValue(m_pEditValue->text());
     }
     
  m_pTextLabelMessage->setText(strMessage);

	if ( strNewName.isEmpty() || (strMessage.length() > 0) )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}

void KXEAttributeDialog::slotValueChanged(const QString & strNewValue)
{
	QString strMessage = checkName(m_pEditQName->text());
  if(strMessage.isEmpty())
     {
       strMessage = checkNamespace(m_pEditNamespace->text());
       if(strMessage.isEmpty())
         strMessage = checkValue(strNewValue);
     }

  m_pTextLabelMessage->setText(strMessage);

	if ( m_pEditQName->text().isEmpty() || (strMessage.length() > 0) )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}

void KXEAttributeDialog::slotNamespaceChanged(const QString & strNewNamespace)
{
	QString strMessage = checkName(m_pEditQName->text());
  if(strMessage.isEmpty())
     {
       strMessage = checkNamespace(strNewNamespace);
       if(strMessage.isEmpty())
         strMessage = checkValue(m_pEditValue->text());
     }

  m_pTextLabelMessage->setText(strMessage);

	if ( m_pEditQName->text().isEmpty() || (strMessage.length() > 0) )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}

// Check, if XML attribute name is OK
QString KXEAttributeDialog::checkNamespace(const QString strAtttributeName)
{
  if(strAtttributeName.length() == 0)
    return  "";

  // test for space 
  if(strAtttributeName.find(' ') >= 0)
    return i18n("Atttribute namespace cannot contain space !");

  // Forbidden characters
  QString strForbiddenChars("<>\"'");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    QChar ch = strForbiddenChars[i];

    if(strAtttributeName.find(ch) >= 0)
      return i18n("Atttribute namespace cannot contain character: %1 !").arg(ch);
  }

  return "";
}

// Check, if XML attribute name is OK
QString KXEAttributeDialog::checkName(const QString strAtttributeName)
{
  if(strAtttributeName.length() == 0)
    return  "";

  // test for space 
  if(strAtttributeName.find(' ') >= 0)
    return i18n("Atttribute name cannot contain space !");

  // Forbidden characters
  QString strForbiddenChars("&@#$%^()%+?=:<>;\"'*");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    QChar ch = strForbiddenChars[i];

    if(strAtttributeName.find(ch) >= 0)
      return i18n("Atttribute name cannot contain character: %1 !").arg(ch);
  }

  return "";
}

// Check, if XML attribute value is OK
QString KXEAttributeDialog::checkValue(const QString strData)
{
  if(strData.length() == 0)
    return  "";

  // Forbidden characters
  QString strForbiddenChars("<>\"");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    QChar ch = strForbiddenChars[i];

    if(strData.find(ch) >= 0)
      return i18n("Attribute value cannot contain character: %1 !").arg(ch);
  }

  return "";
}
