/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __CALIBRATEDIALOG_H
#define __CALIBRATEDIALOG_H

#include <qmap.h>
#include <qstring.h>
#include <qcolor.h>
#include "calibratedlg.h"

class FlossListBoxItem;

/** Wrapper class to manage the calibration of floss colors
    @author Stephen P Allewell
  */
class CalibrateDialog : public CalibrateDlg
{
  Q_OBJECT
public:
  CalibrateDialog(QWidget *);
  virtual ~CalibrateDialog();

protected slots:
  virtual void accept();
  void contextHelp();
  void schemeChanged(int);
  void selectionChanged(QListBoxItem *);
  void redChanged(int);
  void greenChanged(int);
  void blueChanged(int);
  void resetColor();

private:
  void fillSchemeList();
  void fillColorList();
  void updateSample();
  void updateName(bool);
  void commitColor();

  QString           m_scheme;
  QColor            m_sampleColor;
  FlossListBoxItem* m_item;
  QPixmap*          m_sample;

  typedef QMap<QString,QColor>  ChangedColors;        // <colorName,color>
  QMap<QString,ChangedColors>   m_calibratedColors;   // <schemeName,<colorName,color>>
};

#endif
