//LabPlot : Graph4D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph4D.h"

using namespace std;

Graph4D::Graph4D(QString n, QString l, LRange r[4], LSource src, PType t, Style st, 
		Symbol sy, Point4D *p, int nr,bool ty, bool s)
	: Graph(n,l,src,t,st,sy,nr,s)
{
	range = new LRange[4];
	if(r) {
		for(int i=0;i<4;i++) {
			range[i]=r[i];
		}
	}

	ptr = new Point4D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];
	
	gtype = ty;
}

void Graph4D::save(QTextStream *t) {
	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<' ';
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<' '<<range[3].rMin()<<' '<<range[4].rMax()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< number;i++)
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<' '<<ptr[i].T()<<endl;
	*t<<gtype<<endl;
}

void Graph4D::open(QTextStream *t, int version) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1)
		*t>>name>>label>>number;
	else
		*t>>name>>number;

	double xmin, xmax, ymin, ymax, zmin, zmax, tmin, tmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax>>tmin>>tmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	range[3].setMin(tmin);
	range[3].setMax(tmax);
	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	double x, y, z, tt;
	ptr = new Point4D[number];
	for (int i=0;i< number;i++) {
		*t>>x>>y>>z>>tt;
		ptr[i].setPoint(x,y,z,tt);

		kdDebug()<<x<<' '<<y<<' '<<z<<' '<<tt<<endl;
	}
	*t>>tt;
	gtype = (bool)tt;
}

QStringList Graph4D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)		// only possible type
		t=i18n("2D");
	
	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");
	
	// TODO : bool gtype ???
	s << name << t << sh;
	s << QString::number(number) << QString::number(1);
	s << QString::number(range[0].rMin()) + " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());
	s << QString::number(range[3].rMin())+ " .. " + QString::number(range[3].rMax());
	
	return s;
}

// calculate x error range
LRange Graph4D::ErrorDXRange() {
	if(gtype == 1)	// x-y-dy1-dy2
		return range[0];

	double x,z;
	double min=0,max=0;
	for(int i=0;i<number;i++) {
		x=ptr[i].X();
		z=ptr[i].Z();
		if(i==0) {
			min=x-z;
			max=x+z;
		}
		else {
			x-z<min?min=x-z:0;
			x+z>max?max=x+z:0;
		}
	}

	return LRange(min,max);
}

// calculate y error range
LRange Graph4D::ErrorDYRange() {
	double min=0,max=0;
	double x,y,z,t;
	for(int i=0;i<number;i++) {
		x=ptr[i].X();
		y=ptr[i].Y();
		z=ptr[i].Z();
		t=ptr[i].T();
		if(i==0) {
			if(gtype == 0) {
				min=y-t;
				max=y+t;
			}
			else {
				min=y-z;
				max=y+t;
			}
		}
		else {
			if(gtype == 0) {
				y-t<min?min=y-t:0;
				y+t>max?max=y+t:0;
			}
			else {
				y-z<min?min=y-z:0;
				y+t>max?max=y+t:0;
			}
		}
	}

	return LRange(min,max);
}
