//LabPlot : WorksheetDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "WorksheetDialog.h"

//! for general worksheet settings
WorksheetDialog::WorksheetDialog(Worksheet *p, const char *name)
	: Dialog(p, name)
{
	setCaption(i18n("Worksheet Settings")+i18n(" : ")+QString(name));

	QHBox *hb = new QHBox(vbox);
	enabletcb = new QCheckBox(i18n("enable worksheet title :"),hb);
	enabletcb->setChecked(p->TitleEnabled());
	titlele = new KLineEdit(p->Title(),hb);

	hb = new QHBox(vbox);
	new QLabel(i18n("Background Color : "),hb); 
	bgcolor = new KColorButton(p->Background(),hb);

	hb = new QHBox(vbox);
	enablecb = new QCheckBox(i18n("enable time stamp"),hb);
	enablecb->setChecked(p->TimeStampEnabled());

	hb = new QHBox(vbox);
	new QLabel(i18n("Time stamp : "),hb); 
	timestample = new KLineEdit(p->TimeStamp().toString(Qt::TextDate),hb);
	
	KPushButton *update = new KPushButton( i18n("Update time stamp"), hb );
	QObject::connect(update,SIGNAL(clicked()),SLOT(updateTimeStamp()));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void WorksheetDialog::updateTimeStamp() {
#if QT_VERSION > 0x030007
	timestample->setText(QDateTime::currentDateTime(Qt::LocalTime).toString(Qt::TextDate));
#else
	timestample->setText(QDateTime::currentDateTime().toString(Qt::TextDate));
#endif
}

void WorksheetDialog::apply_clicked() {
	p->setBackground(bgcolor->color());
	
	p->setTimeStamp(QDateTime::fromString(timestample->text()));
	p->setTimeStampEnabled(enablecb->isChecked());

	p->setTitle(titlele->text());
	p->setTitleEnabled(enabletcb->isChecked());

	p->updatePixmap();
}
