//LabPlot : CompressListDialog.cc

#include "CompressListDialog.h"
#include "source.h"

using namespace std;

CompressListDialog::CompressListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	setCaption(i18n("Compress Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Compress" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Compress every n points :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nni = new KIntNumInput(config->readNumEntry("N",3),hb);
	nni->setRange(0,1000000,1,false);

	hb = new QHBox(tab1);
	averagecb = new QCheckBox(i18n("Average"),hb);
	averagecb->setChecked(config->readBoolEntry("Average",true));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;

	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void CompressListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Compress" );

	config->writeEntry("N", nni->value());
	config->writeEntry("Average",averagecb->isChecked());
}

int CompressListDialog::apply_clicked() {
	int n = nni->value();

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();

		if(n >= table->numRows()) {
			KMessageBox::error(this,i18n("n bigger than number of rows!\nPlease use a smaller value."));
			return -1;
		}

		// add column if needed
		bool empty = true;
		for(int i = 0; i < table->numRows(); i++) {
			if(!table->text(i, table->numCols()-1).isEmpty())
				empty = false;
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows();i+=n) {
			double sum = 0;
			for (int j=0;j<n;j++) {
				sum+=table->text(i+j,col).toDouble();
			}
			if(averagecb->isChecked())
				sum /= n;

			// insert into last column
			table->setText(i+n/2,newcol,QString::number(sum));
		}
		return 0;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType gtype = gl->getType(item);

	Style *style=0;
	Symbol *symbol=0;
	if(gtype != GRAPHM) {
		style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->value(),(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	if (gtype == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// do compress
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx;i+=n) {
			double x = a[(int) (i+n/2)].X();
			double y = 0;
			for (int j=0;j<n;j++) {
				y+=a[i+j].Y();
			}
			if(averagecb->isChecked())
				y /= n;

			ptr[i/n].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,nx/n,&xmin,&xmax,&ymin,&ymax);

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("compress (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nx/n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (gtype == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx];
		Point3D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		cout<< "TYPE : "<<(int)type<<endl;

		// do it
		double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
		for (int i = 0;i<nx;i+=n) {
			double x = 0, y = 0, z = 0;
			if (type == P2D) {	// 2derr
				x = a[(int) (i+n/2)].X();
				for (int j=0;j<n;j++) {
					y += a[i+j].Y();
					z += a[i+j].Z();
				}
			}
			else {		// 3d
				for (int j = 0;j<n;j++) {
					x+=a[(int)(j+i)].X();
					y+=a[(int)(j+i)].Y();
					z+=a[(int)(j+i)].Z();
				}
			}
			if(averagecb->isChecked()) {
				if (type != P2D) 	// 2derr
					x /= n;
				y /= n;
				z /= n;
			}

			ptr[i/n].setPoint(x,y,z);
		}

		mw->calculateRanges3D(ptr,nx/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);

		QString fun = QString(i18n("compress (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,1);
		ng->setNumberX((int)(g->NX()/n));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem());
	}
	else if (gtype == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx];
		Point4D *a = g->Data();
		bool gtype = g->GType();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		cout<< "TYPE : "<<(int)type<<endl;

		// do it
		double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
		for (int i = 0;i<nx;i+=n) {
			double x = 0, y = 0, z = 0, t=0;
			if (type == P2D) {	// 2derr
				x = a[(int) (i+n/2)].X();
				for (int j=0;j<n;j++) {
					y += a[i+j].Y();
					z += a[i+j].Z();
					t += a[i+j].T();
				}
			}
			if(averagecb->isChecked()) {
				y /= n;
				z /= n;
				t /= n;
			}

			ptr[i/n].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,nx/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);

		// create the new Graph
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);

		QString fun = QString(i18n("compress (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,gtype);
		mw->addGraph4D(ng,sheetcb->currentItem());
	}
	else if (gtype == GRAPHM) {		// PSURFACE and P3D
		GraphM *g = gl->getGraphM(item);
		int N = g->Number();
		int nx = g->NX();
		int ny = g->NY();
		double *ptr = new double[N];
		double *a = g->Data();

		if(n >= nx || n >= ny) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// do it
		double zmin=0, zmax=1;
		for (int i = 0;i<nx;i+=n) {
			for (int j = 0;j<ny;j+=n) {
				double z = 0;

				for (int l=0;l<n;l++) {
					int a1 = i+l;
					for (int k=0;k<n;k++) {
						int a2 = j+k;
						z += a[a2+nx*a1];
					}
				}
				if(averagecb->isChecked())
					z /= n;

				// new ranges
				if (i==0) {
					zmin=zmax=z;
				}
				else {
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}

				ptr[j/n+(nx)*i/n]=z;
			}
		}

		// create the new Graph
		LRange range[3];
		range[0] = LRange(1,nx);
		range[1] = LRange(1,ny);
		range[2] = LRange(zmin,zmax);

		QString fun = QString(i18n("compress (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		GraphM *ng = new GraphM(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx/n,ny/n);
		mw->addGraphM(ng,sheetcb->currentItem(),type);
	}

	updateList();

	return 0;
}
